/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.helditeminfo;

import io.github.a5b84.helditeminfo.HeldItemInfoClient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class TooltipBuilder {
    public static final ChatFormatting DEFAULT_COLOR = ChatFormatting.GRAY;
    public final ItemStack stack;
    private final int maxSize;
    private final List<Component> lines;
    private int realSize = 0;

    public TooltipBuilder(ItemStack stack, int maxSize) {
        this.stack = stack;
        this.maxSize = maxSize;
        this.lines = new ArrayList<Component>(maxSize);
    }

    public boolean canAdd() {
        return this.lines.size() < this.maxSize;
    }

    public int getRemainingLines() {
        return this.maxSize - this.lines.size();
    }

    public void append(Component text) {
        ++this.realSize;
        if (this.canAdd()) {
            this.lines.add(text);
        }
    }

    public void append(Supplier<Component> textSupplier) {
        ++this.realSize;
        if (this.canAdd()) {
            this.lines.add(textSupplier.get());
        }
    }

    public void appendAll(List<? extends Component> newLines) {
        this.realSize += newLines.size();
        if (this.canAdd()) {
            for (Component component : newLines) {
                this.lines.add(component);
                if (this.canAdd()) continue;
                break;
            }
        }
    }

    public List<Component> build() {
        if (this.realSize > this.maxSize && HeldItemInfoClient.config.showHiddenLinesCount()) {
            MutableComponent moreText = Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{this.realSize - this.maxSize + 1}).m_130944_(new ChatFormatting[]{DEFAULT_COLOR, ChatFormatting.ITALIC});
            this.lines.set(this.lines.size() - 1, (Component)moreText);
        }
        return this.lines;
    }
}

