/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.helditeminfo.mixin;

import io.github.a5b84.helditeminfo.Appenders;
import io.github.a5b84.helditeminfo.HeldItemInfoClient;
import io.github.a5b84.helditeminfo.TooltipAppender;
import io.github.a5b84.helditeminfo.TooltipBuilder;
import io.github.a5b84.helditeminfo.TooltipLine;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class HeldItemTooltipMixin {
    @Shadow
    @Final
    private Minecraft f_92986_;
    @Shadow
    private int f_92993_;
    @Shadow
    private ItemStack f_92994_;
    @Shadow
    private int f_92977_;
    @Shadow
    private int f_92978_;
    @Unique
    private List<TooltipLine> tooltip = Collections.emptyList();
    @Unique
    private int y;
    @Unique
    private ItemStack stackBeforeTick;
    @Unique
    private int maxWidth = -1;

    @Inject(method={"renderSelectedItemName(Lnet/minecraft/client/gui/GuiGraphics;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;getFont()Lnet/minecraft/client/gui/Font;")})
    public void onBeforeRenderHeldItemTooltip(CallbackInfo ci) {
        this.y = this.f_92978_ - 50 - 9 - (int)(((float)HeldItemInfoClient.config.lineHeight() - HeldItemInfoClient.config.offsetPerExtraLine()) * (float)(this.tooltip.size() - 1)) - HeldItemInfoClient.config.verticalOffset();
        if (!this.f_92986_.f_91072_.m_105205_()) {
            this.y += 14;
        }
        if (HeldItemInfoClient.config.showName() && this.tooltip.size() > 1) {
            this.y -= HeldItemInfoClient.config.itemNameSpacing();
        }
    }

    @Redirect(method={"renderSelectedItemName(Lnet/minecraft/client/gui/GuiGraphics;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V"))
    private void fillBackgroundProxy(GuiGraphics context, int x1, int y1, int x2, int y2, int color) {
        if ((color & 0xFF000000) != 0) {
            if (this.maxWidth < 0) {
                for (TooltipLine line : this.tooltip) {
                    if (line.width <= this.maxWidth) continue;
                    this.maxWidth = line.width;
                }
            }
            int height = HeldItemInfoClient.config.lineHeight() * this.tooltip.size();
            if (HeldItemInfoClient.config.showName() && this.tooltip.size() > 1) {
                height += HeldItemInfoClient.config.itemNameSpacing();
            }
            context.m_280509_((this.f_92977_ - this.maxWidth) / 2 - 2, this.y - 2, (this.f_92977_ + this.maxWidth) / 2 + 2, this.y + height + 2, color);
        }
    }

    @Redirect(method={"renderSelectedItemName(Lnet/minecraft/client/gui/GuiGraphics;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;III)I"))
    private int drawTextProxy(GuiGraphics context, Font textRenderer, Component name, int _x, int _y, int color) {
        int lineHeight = HeldItemInfoClient.config.lineHeight();
        int i = 0;
        for (TooltipLine line : this.tooltip) {
            int x = (this.f_92977_ - line.width) / 2;
            context.m_280430_(textRenderer, line.text, x, this.y, color);
            this.y += lineHeight;
            if (i == 0 && HeldItemInfoClient.config.showName()) {
                this.y += HeldItemInfoClient.config.itemNameSpacing();
            }
            ++i;
        }
        return 0;
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void onBeforeTick(CallbackInfo ci) {
        this.stackBeforeTick = this.f_92994_;
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    public void onAfterTick(CallbackInfo ci) {
        if (this.f_92986_.f_91074_ != null && this.f_92994_ != this.stackBeforeTick) {
            if (this.f_92994_.m_41619_()) {
                this.tooltip = Collections.emptyList();
            } else {
                List<Component> newInfo = this.buildTooltip(this.f_92994_);
                if (!TooltipLine.areEquivalent(this.tooltip, newInfo)) {
                    this.tooltip = TooltipLine.from(newInfo);
                    this.maxWidth = -1;
                    this.f_92993_ = (int)(20.0f * (HeldItemInfoClient.config.baseFadeDuration() + HeldItemInfoClient.config.fadeDurationPerExtraLine() * (float)(this.tooltip.size() - 1)));
                }
            }
        }
    }

    @Unique
    private List<Component> buildTooltip(ItemStack stack) {
        TooltipAppender appender;
        BlockItem blockItem;
        Block var6;
        TooltipAppender appender2;
        Item item;
        if (stack.m_41619_()) {
            return Collections.emptyList();
        }
        TooltipBuilder builder = new TooltipBuilder(stack, HeldItemInfoClient.config.maxLines());
        if (HeldItemInfoClient.config.showName()) {
            MutableComponent stackName = Component.m_237119_().m_7220_(stack.m_41786_()).m_130940_(stack.m_41791_().f_43022_);
            if (stack.m_41788_()) {
                stackName.m_130940_(ChatFormatting.ITALIC);
            }
            builder.append((Component)stackName);
        }
        if ((item = stack.m_41720_()) instanceof TooltipAppender && (appender2 = (TooltipAppender)item).heldItemInfo_shouldAppendTooltip()) {
            appender2.heldItemInfo_appendTooltip(builder);
        }
        if (item instanceof BlockItem && (var6 = (blockItem = (BlockItem)item).m_40614_()) instanceof TooltipAppender && (appender = (TooltipAppender)var6).heldItemInfo_shouldAppendTooltip()) {
            appender.heldItemInfo_appendTooltip(builder);
        }
        if (stack.m_41782_()) {
            if (HeldItemInfoClient.config.showEnchantments()) {
                Appenders.appendEnchantments(builder);
            }
            if (HeldItemInfoClient.config.showContainerContent()) {
                Appenders.appendContainerContent(builder);
            }
            if (HeldItemInfoClient.config.showLore()) {
                Appenders.appendLore(builder);
            }
            if (HeldItemInfoClient.config.showUnbreakable()) {
                Appenders.appendUnbreakable(builder);
            }
        }
        return builder.build();
    }
}

