/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.helditeminfo.mixin.block;

import io.github.a5b84.helditeminfo.HeldItemInfoClient;
import io.github.a5b84.helditeminfo.TooltipAppender;
import io.github.a5b84.helditeminfo.TooltipBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.SpawnerBlock;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={SpawnerBlock.class})
public class SpawnerBlocksMixin
implements TooltipAppender {
    @Override
    public boolean heldItemInfo_shouldAppendTooltip() {
        return HeldItemInfoClient.config.showSpawnerEntity();
    }

    @Override
    public void heldItemInfo_appendTooltip(TooltipBuilder builder) {
        String spawnDataKey = "BlockEntityTag.SpawnData";
        Component text = this.getSpawnEntityDisplayName(builder.stack, spawnDataKey);
        if (text != null) {
            builder.append(text);
        }
    }

    private Component getSpawnEntityDisplayName(ItemStack stack, String nbtPath) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        CompoundTag spawnData = tag.m_128469_(nbtPath);
        if (spawnData.m_128456_()) {
            return null;
        }
        CompoundTag entityTag = spawnData.m_128469_("entity");
        String entityId = entityTag.m_128461_("id");
        if (entityId.isEmpty()) {
            return null;
        }
        return Component.m_237115_((String)("entity." + entityId.replace(':', '.')));
    }
}

