/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.helditeminfo.mixin.item;

import com.google.gson.JsonParseException;
import io.github.a5b84.helditeminfo.HeldItemInfoClient;
import io.github.a5b84.helditeminfo.TooltipAppender;
import io.github.a5b84.helditeminfo.TooltipBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.SignItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SignItem.class})
public abstract class SignItemMixin
implements TooltipAppender {
    @Override
    public boolean heldItemInfo_shouldAppendTooltip() {
        return HeldItemInfoClient.config.showSignText();
    }

    @Override
    public void heldItemInfo_appendTooltip(TooltipBuilder builder) {
        CompoundTag blockEntityTag = builder.stack.m_41737_("BlockEntityTag");
        if (blockEntityTag != null) {
            List<MutableComponent> frontLines = this.buildSide(blockEntityTag, "front_text");
            List<MutableComponent> backLines = this.buildSide(blockEntityTag, "back_text");
            if (!frontLines.isEmpty()) {
                builder.appendAll(frontLines);
                if (!backLines.isEmpty()) {
                    builder.append((Component)Component.m_237113_((String)"-------").m_130940_(TooltipBuilder.DEFAULT_COLOR));
                }
            }
            if (!backLines.isEmpty()) {
                builder.appendAll(backLines);
            }
        }
    }

    @Unique
    private List<MutableComponent> buildSide(CompoundTag blockEntityTag, String sideKey) {
        ListTag messages = blockEntityTag.m_128469_(sideKey).m_128437_("messages", 8);
        if (messages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>(4);
        int i = -1;
        Iterator var6 = messages.iterator();
        while (true) {
            String str;
            MutableComponent text;
            if (!var6.hasNext()) {
                for (MutableComponent line : lines) {
                    line.m_130940_(TooltipBuilder.DEFAULT_COLOR);
                }
                return lines;
            }
            Tag element = (Tag)var6.next();
            ++i;
            if (!(element instanceof StringTag)) continue;
            StringTag message = (StringTag)element;
            try {
                String textJson = message.m_7916_();
                text = Component.Serializer.m_130701_((String)textJson);
            }
            catch (JsonParseException jsonParseException) {
                continue;
            }
            if (text == null || (str = text.getString()).isBlank()) continue;
            if (!lines.isEmpty()) {
                while (lines.size() < i) {
                    lines.add(Component.m_237119_());
                }
            }
            lines.add(Component.m_237113_((String)str));
        }
    }
}

