/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.anotherliquidmilkmod.data;

import com.mrbysco.anotherliquidmilkmod.registry.MilkRegistry;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class MilkDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(true, (DataProvider)new MilkLanguage(packOutput));
        generator.addProvider(true, (DataProvider)new MilkModels(packOutput));
    }

    private static class MilkLanguage
    extends LanguageProvider {
        public MilkLanguage(PackOutput packOutput) {
            super(packOutput, "almm", "en_us");
        }

        protected void addTranslations() {
            this.addConfig("General", "General", "General Settings");
            this.addConfig("liquidCuresEffects", "Liquid Cures Effects", "Makes the liquid milk cure effects [default: true]");
        }

        private void addConfig(String path, String name, @Nullable String description) {
            this.add("almm.configuration." + path, name);
            if (description != null && !description.isEmpty()) {
                this.add("almm.configuration." + path + ".tooltip", description);
            }
        }
    }

    private static class MilkModels
    extends ModelProvider {
        public MilkModels(PackOutput packOutput) {
            super(packOutput, "almm");
        }

        protected void registerModels(BlockModelGenerators blockModels, @NotNull ItemModelGenerators itemModels) {
            blockModels.createNonTemplateModelBlock((Block)MilkRegistry.MILK_FLUID_BLOCK.get());
        }
    }
}

