/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.anotherliquidmilkmod.handler;

import com.mrbysco.anotherliquidmilkmod.registry.MilkRegistry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class MilkHandler {
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemstack = event.getItemStack();
        if (itemstack.is(Items.MILK_BUCKET)) {
            Player player;
            Level level = event.getLevel();
            BlockHitResult hitResult = Item.getPlayerPOVHitResult((Level)level, (Player)(player = event.getEntity()), (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (hitResult.getType() == HitResult.Type.MISS) {
                event.setCancellationResult((InteractionResult)InteractionResult.PASS);
            } else if (hitResult.getType() != HitResult.Type.BLOCK) {
                event.setCancellationResult((InteractionResult)InteractionResult.PASS);
            } else {
                BlockPos pos = hitResult.getBlockPos();
                Direction direction = hitResult.getDirection();
                BlockPos relativePos = pos.relative(direction);
                if (level.mayInteract((Entity)player, pos) && player.mayUseItemAt(relativePos, direction, itemstack)) {
                    if (player instanceof ServerPlayer) {
                        CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, relativePos, itemstack);
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)itemstack.getItem()));
                    if (!player.getAbilities().instabuild) {
                        itemstack.shrink(1);
                        ItemStack bucketStack = new ItemStack((ItemLike)Items.BUCKET);
                        if (!player.addItem(bucketStack)) {
                            Containers.dropItemStack((Level)player.level(), (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)bucketStack);
                        }
                    }
                    level.setBlock(relativePos, MilkRegistry.MILK.get().defaultFluidState().createLegacyBlock(), 11);
                    level.playSound(null, relativePos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                }
            }
        }
    }
}

