/*
 * Decompiled with CFR 0.152.
 */
package com.starmaster.dragonhealth;

import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DragonHealthPlugin
extends JavaPlugin
implements Listener {
    private double dragonHealth = 600.0;

    public void onEnable() {
        this.saveDefaultConfig();
        this.dragonHealth = this.getConfig().getDouble("dragon-health", 600.0);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("DragonHealthPlugin enabled! Ender Dragon health set to " + this.dragonHealth);
    }

    public void onDisable() {
        this.getLogger().info("DragonHealthPlugin disabled!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("dragonhealth")) {
            if (!sender.hasPermission("dragonhealth.admin")) {
                sender.sendMessage("\u00a7cYou don't have permission to use this command!");
                return true;
            }
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                this.reloadConfig();
                this.dragonHealth = this.getConfig().getDouble("dragon-health", 600.0);
                sender.sendMessage("\u00a7aDragonHealthPlugin reloaded! Dragon health set to " + this.dragonHealth);
                this.getLogger().info("Configuration reloaded by " + sender.getName());
                return true;
            }
            sender.sendMessage("\u00a76DragonHealthPlugin v1.0.0");
            sender.sendMessage("\u00a77Current dragon health: \u00a7e" + this.dragonHealth);
            sender.sendMessage("\u00a77Use \u00a7e/dragonhealth reload \u00a77to reload config");
            return true;
        }
        return false;
    }

    @EventHandler
    public void onDragonSpawn(CreatureSpawnEvent event) {
        if (event.getEntityType() == EntityType.ENDER_DRAGON) {
            final EnderDragon dragon = (EnderDragon)event.getEntity();
            this.applyDragonHealth(dragon);
            new BukkitRunnable(){

                public void run() {
                    if (dragon.isValid() && !dragon.isDead()) {
                        DragonHealthPlugin.this.applyDragonHealth(dragon);
                    }
                }
            }.runTaskLater((Plugin)this, 1L);
            new BukkitRunnable(){

                public void run() {
                    if (dragon.isValid() && !dragon.isDead()) {
                        DragonHealthPlugin.this.applyDragonHealth(dragon);
                    }
                }
            }.runTaskLater((Plugin)this, 5L);
            new BukkitRunnable(){

                public void run() {
                    if (dragon.isValid() && !dragon.isDead()) {
                        DragonHealthPlugin.this.applyDragonHealth(dragon);
                        DragonHealthPlugin.this.getLogger().info("Final health check: Dragon has " + dragon.getHealth() + "/" + dragon.getMaxHealth() + " HP");
                    }
                }
            }.runTaskLater((Plugin)this, 20L);
        }
    }

    private void applyDragonHealth(EnderDragon dragon) {
        try {
            Attribute attr;
            AttributeInstance maxHealthAttribute = null;
            Attribute[] attributeArray = Attribute.values();
            int n = attributeArray.length;
            for (int i = 0; !(i >= n || (attr = attributeArray[i]).name().contains("MAX_HEALTH") && (maxHealthAttribute = dragon.getAttribute(attr)) != null); ++i) {
            }
            if (maxHealthAttribute != null) {
                maxHealthAttribute.setBaseValue(this.dragonHealth);
            }
            dragon.setMaxHealth(this.dragonHealth);
            dragon.setHealth(this.dragonHealth);
        }
        catch (Exception e) {
            this.getLogger().warning("Could not set dragon health: " + e.getMessage());
            try {
                dragon.setMaxHealth(this.dragonHealth);
                dragon.setHealth(this.dragonHealth);
            }
            catch (Exception ex) {
                this.getLogger().severe("Failed to set dragon health completely: " + ex.getMessage());
            }
        }
    }
}

