package stfu.mixin.DisableWorldAdvice;

import com.mojang.serialization.Lifecycle;
import net.minecraft.class_310;
import net.minecraft.class_5219;
import net.minecraft.class_525;
import net.minecraft.class_7196;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import stfu.config.Config;

@Mixin(class_7196.class)
abstract class WorldOpenFlowsMixin {
    @Inject(method = "confirmWorldCreation", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V", ordinal = 0), cancellable = true)
    private static void confirmWorldCreation(class_310 client, class_525 parent, Lifecycle lifecycle, Runnable loader, boolean bypassWarnings, CallbackInfo ci) {
        if (Config.get().disableWorldAdvice) {
            loader.run();
            ci.cancel();
        }
    }

    @Redirect(method = {"openWorldCheckWorldStemCompatibility", "doLoadLevel"}, at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/storage/WorldData;worldGenSettingsLifecycle()Lcom/mojang/serialization/Lifecycle;"))
    private Lifecycle openWorldCheckWorldStemCompatibility(class_5219 saveProperties) {
        if (Config.get().disableWorldAdvice) return Lifecycle.stable();
        return saveProperties.method_29588();
    }
}
