package stfu.mixin;

import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import stfu.config.Config;

@Mixin(class_757.class)
public class NoNightVisionFlicker {
    @Inject(method = "getNightVisionScale", at = @At("HEAD"), cancellable = true)
    private static void getNightVisionScale(class_1309 entity, float tickProgress, CallbackInfoReturnable<Float> cir) {
        if (Config.get().nightVisionFlicker) return;
        float statusEffectInstance = ((float) entity.method_6112(class_1294.field_5925).method_5584() - tickProgress) / 20F;
        cir.setReturnValue(statusEffectInstance == -1 ? 1F : Math.min(statusEffectInstance, 1F));
    }
}
