package stfu.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import stfu.DisableIf;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2477;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import net.minecraft.class_8000;

import static stfu.Main.client;

@Mixin(class_332.class)
@DisableIf({"legacy", "legendarytooltips"})
public abstract class Tooltips {
    @Shadow public abstract int guiWidth();

    @ModifyVariable(method = /*? > 1.21 {*/"renderTooltip"/*?}else{*//*"renderTooltipInternal"*//*?}*/,
            at = @At("HEAD"), index = 2, argsOnly = true)
    private List<class_5684> wrapLines(List<class_5684> original) {
        ArrayList<class_5684> components = new ArrayList<>();

        for (class_5684 tooltipComponent : original) {
            if (!(tooltipComponent instanceof class_5683 component)) {
                components.add(tooltipComponent);
                continue;
            }
            final int length = components.size();
            client.field_1772.method_27527().method_29971(new class_5348() {
                @Override
                public <T> Optional<T> method_27657(class_5245<T> visitor) {
                    return method_27658((s, t)->visitor.accept(t), class_2583.field_24360);
                }

                @Override
                public <T> Optional<T> method_27658(class_5246<T> visitor, class_2583 s) {
                    component.field_27997.accept((index, style, codePoint) -> visitor.accept(style.method_27702(s), new String(Character.toChars(codePoint))).isEmpty());
                    return Optional.empty();
                }
            }, guiWidth() - 12, class_2583.field_24360, (t, lastLineWrapped) -> components.add(class_5684.method_32662(class_2477.method_10517().method_30934(t))));
            if (components.size() == length) components.add(class_5684.method_32662(class_5481.method_34905()));
        }

        return components;
    }

    @WrapOperation(method = /*? > 1.21 {*/"renderTooltip"/*?}else{*//*"renderTooltipInternal"*//*?}*/,
            at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;positionTooltip(IIIIII)Lorg/joml/Vector2ic;"))
    private Vector2ic reposition(class_8000 instance, int screenWidth, int screenHeight, int mouseX, int mouseY, int width, int height, Operation<Vector2ic> original) {
        Vector2ic vector2ic = original.call(instance, screenWidth, screenHeight, mouseX, mouseY, width, height);
        int x = Math.max(6, Math.min(vector2ic.x(), screenWidth - width - 6));
        int y = Math.max(6, Math.min(vector2ic.y(), screenHeight - height - 6));
        if (x == 6 && y != 6 && width + 12 <= screenWidth) {
            x = Math.min(screenWidth - width - 6, Math.max(mouseX - width / 2, 6));
            y = mouseY - height - 12;

            if (y < 6) {
                if (screenHeight - mouseY > mouseY) y = mouseY + 12;
                else y = 6;
            }
        }
        return new Vector2i(x, y);
    }
}
