package stfu.mixin.chat;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import stfu.config.Config;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_303;
import net.minecraft.class_338;
import net.minecraft.class_5250;

@Mixin(class_338.class)
public abstract class Deduplicate {
    @Unique
    private static final class_2583 OCCURRENCES = class_2583.field_24360.method_10977(class_124.field_1080);
    @Shadow
    @Final
    private List<class_303> allMessages;

    @Shadow(aliases = {"refreshTrimmedMessage"})
    protected abstract void refreshTrimmedMessages();

    @ModifyVariable(
            method = "addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V",
            at = @At("HEAD"),
            argsOnly = true
    )
    private class_2561 compact(class_2561 message) {
        if (Config.get().compactChat == Config.CompactChat.NEVER || allMessages.isEmpty()) return message;
        // Skip common separators
        boolean isSeparator = true;
        for (char c : message.getString().trim().toCharArray())
            if (c != ' ' && c != '=' && c != '-' && c != '_' && c != '~') {
                isSeparator = false;
                break;
            }
        if (isSeparator) return message;

        // Find matching messages
        int matches = 0;
        for (class_303 other : Config.get().compactChat == Config.CompactChat.ONLY_CONSECUTIVE ? List.of(allMessages.get(0)) : allMessages) {
            class_2561 content = other.comp_893();
            if (!content.method_10851().equals(message.method_10851()) || !content.method_10866().equals(message.method_10866())) continue;

            // Check siblings without occurrences count
            List<class_2561> siblings = content.method_10855();
            String o = null;
            if (!siblings.isEmpty()) {
                class_2561 last = siblings.get(siblings.size() - 1);
                if (last.method_10866() == OCCURRENCES) {
                    String raw = last.getString();
                    if (raw != null && raw.startsWith(" (") && raw.endsWith(")")) {
                        o = raw.substring(2, raw.length() - 1);
                        siblings.remove(siblings.size() - 1);
                    }
                }
            }
            if (!siblings.equals(message.method_10855())) continue;

            // Increment occurrences count
            if (o == null) matches = 2;
            else try {
                matches = Integer.parseInt(o) + 1;
            } catch (NumberFormatException e) {
                continue;
            }
            // remove previous message
            allMessages.remove(other);
            refreshTrimmedMessages();
            break; // Trust the previous message
        }
        // Append occurrences count
        if (matches > 1) {
            if (message instanceof class_5250 mutable) try {
                return mutable.method_10852(class_2561.method_43470(" (" + matches + ")").method_10862(OCCURRENCES));
            } catch (UnsupportedOperationException ignored) {} // MutableText is not always mutable? in this case use copy to assure it is backed by an arraylist
            return message.method_27661().method_10852(class_2561.method_43470(" (" + matches + ")").method_10862(OCCURRENCES));
        }
        return message;
    }
}
