package stfu.mixin.rendering;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import stfu.config.Config;
import net.minecraft.class_10266;
import net.minecraft.class_2779;
import net.minecraft.class_634;
//? > 1.21 {
import org.objectweb.asm.Opcodes;

@Mixin(class_634.class)
abstract class DisableToasts {
    //? > 1.21 {
    @Redirect(method = "handleLogin", at = @At(value = "FIELD", target = "Lnet/minecraft/client/multiplayer/ClientPacketListener;seenInsecureChatWarning:Z", opcode = Opcodes.GETFIELD))
    private boolean onGameJoin(class_634 instance) {
        return true;
    }

    @Redirect(
            method = "handleRecipeBookAdd",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/network/protocol/game/ClientboundRecipeBookAddPacket$Entry;notification()Z")
    )
    private boolean disableRecipeToasts(class_10266.class_10267 instance) {
        return Config.get().recipeToasts && instance.method_64561();
    }
//?} else {
    /*@Redirect(method = "handleServerData", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/protocol/game/ClientboundServerDataPacket;enforcesSecureChat()Z", ordinal = 1))
    private boolean isSecureChatEnforced(ClientboundServerDataPacket instance) {
        return true;
    }

    @Redirect(
            method = "method_34011",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/crafting/Recipe;showNotification()Z")
    )
    private boolean disableRecipeToasts(Recipe<?> instance) {
        return Config.get().recipeToasts && instance.showNotification();
    }
*///?}

    @Inject(method = "handleUpdateAdvancementsPacket", at = @At("HEAD"), cancellable = true)
    private void disableAdvancementToasts(class_2779 packet, CallbackInfo ci) {
        if (!Config.get().advancementToasts) ci.cancel();
    }
}
