/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.context;

import earth.terrarium.common_storage_lib.lookup.ItemLookup;
import earth.terrarium.common_storage_lib.resources.item.ItemResource;
import earth.terrarium.common_storage_lib.storage.base.CommonStorage;
import earth.terrarium.common_storage_lib.storage.base.StorageIO;
import earth.terrarium.common_storage_lib.storage.base.StorageSlot;
import earth.terrarium.common_storage_lib.storage.base.UpdateManager;
import earth.terrarium.common_storage_lib.storage.util.TransferUtil;
import net.minecraft.class_9322;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;

public interface ItemContext
extends StorageIO<ItemResource>,
class_9322 {
    default public <T> T find(ItemLookup<T, ItemContext> lookup) {
        return (T)lookup.find(this.getResource().toStack((int)this.getAmount()), (Object)this);
    }

    default public boolean isPresent(ItemLookup<?, ItemContext> lookup) {
        return lookup.isPresent(this.getResource().getCachedStack(), (Object)this);
    }

    default public ItemResource getResource() {
        return this.mainSlot().getResource();
    }

    default public long getAmount() {
        return this.mainSlot().getAmount();
    }

    @Override
    default public long insert(ItemResource resource, long amount, boolean simulate) {
        long overflow;
        long inserted = this.mainSlot().insert(resource, amount, simulate);
        long l = overflow = inserted < amount ? this.outerContainer().insert(resource, amount - inserted, simulate) : 0L;
        if (!simulate) {
            this.updateAll();
        }
        return inserted + overflow;
    }

    @Override
    default public long extract(ItemResource resource, long amount, boolean simulate) {
        long extract = this.mainSlot().extract(resource, amount, simulate);
        if (!simulate) {
            this.updateAll();
        }
        return extract;
    }

    default public long exchange(ItemResource newResource, long amount, boolean simulate) {
        long exchange = TransferUtil.exchange(this, this.getResource(), newResource, amount, simulate);
        if (!simulate) {
            this.updateAll();
        }
        return exchange;
    }

    @Deprecated
    default public boolean modify(class_9326 patch) {
        return this.exchange(this.getResource().modify(patch), this.getAmount(), false) == this.getAmount();
    }

    default public <T> boolean set(class_9331<T> type, T value) {
        return this.exchange(this.getResource().set(type, value), this.getAmount(), false) == this.getAmount();
    }

    @NotNull
    default public class_9323 method_57353() {
        return this.getResource().method_57353();
    }

    public CommonStorage<ItemResource> outerContainer();

    public StorageSlot<ItemResource> mainSlot();

    default public void updateAll() {
        UpdateManager.batch(this.outerContainer(), this.mainSlot());
    }
}

