/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.energy.impl;

import earth.terrarium.common_storage_lib.context.ItemContext;
import earth.terrarium.common_storage_lib.data.DataManager;
import earth.terrarium.common_storage_lib.storage.base.UpdateManager;
import earth.terrarium.common_storage_lib.storage.base.ValueStorage;
import net.minecraft.class_9331;

public class SimpleValueStorage
implements ValueStorage,
UpdateManager<Long> {
    private final long capacity;
    private final Runnable onUpdate;
    private final Runnable save;
    private long amount;

    public SimpleValueStorage(long capacity) {
        this.capacity = capacity;
        this.onUpdate = () -> {};
        this.save = () -> {};
    }

    public SimpleValueStorage(ItemContext context, class_9331<Long> componentType, long capacity) {
        this.capacity = capacity;
        this.onUpdate = context::updateAll;
        this.save = () -> context.set(componentType, this.amount);
        if (context.getResource().method_57826(componentType)) {
            this.amount = (Long)context.getResource().method_57824(componentType);
        }
    }

    public SimpleValueStorage(Object entityOrBlockEntity, DataManager<Long> dataManager, long capacity) {
        this.capacity = capacity;
        this.onUpdate = () -> dataManager.set(entityOrBlockEntity, (Object)this.amount);
        this.save = () -> {};
        this.amount = (Long)dataManager.get(entityOrBlockEntity);
    }

    @Override
    public long getStoredAmount() {
        return this.amount;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    public void set(long amount) {
        this.amount = amount;
    }

    @Override
    public boolean allowsInsertion() {
        return true;
    }

    @Override
    public boolean allowsExtraction() {
        return true;
    }

    @Override
    public long insert(long amount, boolean simulate) {
        long inserted = Math.min(amount, this.capacity - this.amount);
        if (!simulate) {
            this.amount += inserted;
            this.save.run();
        }
        return inserted;
    }

    @Override
    public long extract(long amount, boolean simulate) {
        long extracted = Math.min(amount, this.amount);
        if (!simulate) {
            this.amount -= extracted;
            this.save.run();
        }
        return extracted;
    }

    @Override
    public Long createSnapshot() {
        return this.amount;
    }

    @Override
    public void readSnapshot(Long snapshot) {
        this.amount = snapshot;
    }

    @Override
    public void update() {
        this.onUpdate.run();
    }
}

