/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.energy.lookup;

import earth.terrarium.common_storage_lib.context.ItemContext;
import earth.terrarium.common_storage_lib.energy.impl.AutoUpdatingValueStorage;
import earth.terrarium.common_storage_lib.lookup.ItemLookup;
import earth.terrarium.common_storage_lib.storage.base.ValueStorage;
import earth.terrarium.common_storage_lib.storage.common.CommonValueStorage;
import earth.terrarium.common_storage_lib.storage.context.CommonItemContext;
import earth.terrarium.common_storage_lib.storage.context.FabricItemContext;
import earth.terrarium.common_storage_lib.storage.fabric.FabricLongStorage;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class EnergyItemLookup
implements ItemLookup<ValueStorage, ItemContext> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public ValueStorage find(class_1799 stack, ItemContext context) {
        ValueStorage rootContainer;
        Object object;
        EnergyStorage storage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)new FabricItemContext(context));
        if (storage == null) {
            return null;
        }
        if (!(storage instanceof FabricLongStorage)) return new CommonValueStorage(storage);
        FabricLongStorage fabricLongStorage = (FabricLongStorage)storage;
        try {
            rootContainer = object = fabricLongStorage.container();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object ignored = object = fabricLongStorage.snapshotParticipant();
        return new AutoUpdatingValueStorage(rootContainer);
    }

    public void onRegister(Consumer<ItemLookup.ItemRegistrar<ValueStorage, ItemContext>> registrar) {
        registrar.accept((ItemLookup.ItemRegistrar<ValueStorage, ItemContext>)((ItemLookup.ItemRegistrar)this::registerSelf));
    }

    public void registerSelf(ItemLookup.ItemGetter<ValueStorage, ItemContext> getter, class_1792 ... items) {
        EnergyStorage.ITEM.registerForItems((stack, context) -> {
            ValueStorage container = (ValueStorage)getter.getContainer(stack, (Object)new CommonItemContext((ContainerItemContext)context));
            if (container == null) {
                return null;
            }
            return new FabricLongStorage(container);
        }, (class_1935[])items);
    }

    public void registerFallback(ItemLookup.ItemGetter<ValueStorage, ItemContext> getter) {
        EnergyStorage.ITEM.registerFallback((stack, context) -> {
            ValueStorage container = (ValueStorage)getter.getContainer(stack, (Object)new CommonItemContext((ContainerItemContext)context));
            if (container == null) {
                return null;
            }
            return new FabricLongStorage(container);
        });
    }

    public void registerFallback(ItemLookup.ItemGetter<ValueStorage, ItemContext> getter, Predicate<class_1792> itemPredicate) {
        this.registerFallback(getter);
    }
}

