/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.fluid.impl;

import earth.terrarium.common_storage_lib.resources.Resource;
import earth.terrarium.common_storage_lib.resources.ResourceStack;
import earth.terrarium.common_storage_lib.resources.fluid.FluidResource;
import earth.terrarium.common_storage_lib.storage.base.StorageSlot;
import earth.terrarium.common_storage_lib.storage.base.UpdateManager;
import java.util.function.Predicate;

public class SimpleFluidSlot
implements StorageSlot<FluidResource>,
UpdateManager<ResourceStack<FluidResource>> {
    private final long limit;
    private final Runnable update;
    private final Runnable save;
    private FluidResource resource = FluidResource.BLANK;
    private long amount = this.getAmount();

    public SimpleFluidSlot(long limit, Runnable update, Runnable save) {
        this.limit = limit;
        this.update = update;
        this.save = save;
    }

    public SimpleFluidSlot(long limit, Runnable update) {
        this(limit, update, () -> {});
    }

    @Override
    public long getLimit(FluidResource resource) {
        return this.limit;
    }

    @Override
    public boolean isResourceValid(FluidResource resource) {
        return true;
    }

    @Override
    public FluidResource getResource() {
        return this.resource;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public long insert(FluidResource resource, long amount, boolean simulate) {
        if (!this.isResourceValid(resource)) {
            return 0L;
        }
        if (this.resource.isBlank()) {
            long inserted = Math.min(amount, this.limit);
            if (!simulate) {
                this.resource = resource;
                this.amount = inserted;
                this.save.run();
            }
            return inserted;
        }
        if (this.resource.equals(resource)) {
            long inserted = Math.min(amount, this.limit - this.amount);
            if (!simulate) {
                this.amount += inserted;
                this.save.run();
            }
            return inserted;
        }
        return 0L;
    }

    @Override
    public long extract(FluidResource resource, long amount, boolean simulate) {
        if (this.resource.equals(resource)) {
            long extracted = Math.min(amount, this.amount);
            if (!simulate) {
                this.amount -= extracted;
                if (this.amount == 0L) {
                    this.resource = FluidResource.BLANK;
                }
                this.save.run();
            }
            return extracted;
        }
        return 0L;
    }

    @Override
    public ResourceStack<FluidResource> createSnapshot() {
        return new ResourceStack((Resource)this.resource, this.amount);
    }

    @Override
    public void readSnapshot(ResourceStack<FluidResource> snapshot) {
        this.resource = (FluidResource)snapshot.resource();
        this.amount = snapshot.amount();
    }

    @Override
    public void update() {
        this.update.run();
    }

    public static class Filtered
    extends SimpleFluidSlot {
        private final Predicate<FluidResource> filter;

        public Filtered(long limit, Runnable update, Predicate<FluidResource> filter) {
            super(limit, update);
            this.filter = filter;
        }

        @Override
        public boolean isResourceValid(FluidResource resource) {
            return this.filter.test(resource);
        }
    }
}

