/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.fluid.impl;

import earth.terrarium.common_storage_lib.context.ItemContext;
import earth.terrarium.common_storage_lib.data.DataManager;
import earth.terrarium.common_storage_lib.fluid.impl.SimpleFluidSlot;
import earth.terrarium.common_storage_lib.fluid.util.FluidStorageData;
import earth.terrarium.common_storage_lib.resources.fluid.FluidResource;
import earth.terrarium.common_storage_lib.storage.base.CommonStorage;
import earth.terrarium.common_storage_lib.storage.base.UpdateManager;
import earth.terrarium.common_storage_lib.storage.util.TransferUtil;
import java.util.function.Predicate;
import net.minecraft.class_2371;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;

public class SimpleFluidStorage
implements CommonStorage<FluidResource>,
UpdateManager<FluidStorageData> {
    protected final class_2371<SimpleFluidSlot> slots;
    private final Runnable update;
    private final Runnable save;
    private final long limit;

    public SimpleFluidStorage(int size, long limit) {
        this.slots = class_2371.method_10213((int)size, (Object)new SimpleFluidSlot(limit, this::update));
        this.limit = limit;
        this.update = () -> {};
        this.save = () -> {};
    }

    public SimpleFluidStorage(ItemContext context, class_9331<FluidStorageData> componentType, int size, long limit) {
        this.slots = class_2371.method_10213((int)size, (Object)new SimpleFluidSlot(limit, this::update));
        this.limit = limit;
        this.update = context::updateAll;
        this.save = () -> context.set(componentType, FluidStorageData.from(this));
        FluidStorageData data = (FluidStorageData)context.getResource().method_57824(componentType);
        if (data != null) {
            this.readSnapshot(data);
        }
    }

    public SimpleFluidStorage(Object entityOrBlockEntity, DataManager<FluidStorageData> manager, int size, long limit) {
        this.slots = class_2371.method_10213((int)size, (Object)new SimpleFluidSlot(limit, this::update));
        this.limit = limit;
        this.update = () -> {
            FluidStorageData data = FluidStorageData.from(this);
            manager.set(entityOrBlockEntity, (Object)data);
        };
        this.save = () -> {};
        this.readSnapshot((FluidStorageData)manager.get(entityOrBlockEntity));
    }

    public SimpleFluidStorage filter(int slot, Predicate<FluidResource> predicate) {
        this.slots.set(slot, (Object)new SimpleFluidSlot.Filtered(this.limit, this::update, predicate));
        return this;
    }

    @Override
    public int size() {
        return this.slots.size();
    }

    @NotNull
    public SimpleFluidSlot get(int index) {
        return (SimpleFluidSlot)this.slots.get(index);
    }

    @Override
    public FluidStorageData createSnapshot() {
        return FluidStorageData.from(this);
    }

    @Override
    public void readSnapshot(FluidStorageData snapshot) {
        for (int i = 0; i < this.slots.size() && i < snapshot.stacks().size(); ++i) {
            ((SimpleFluidSlot)this.slots.get(i)).readSnapshot(snapshot.stacks().get(i));
        }
    }

    @Override
    public void update() {
        this.update.run();
    }

    @Override
    public long insert(FluidResource resource, long amount, boolean simulate) {
        return TransferUtil.insertSlots(this, resource, amount, simulate);
    }

    @Override
    public long extract(FluidResource resource, long amount, boolean simulate) {
        return TransferUtil.extractSlots(this, resource, amount, simulate);
    }
}

