/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.item.impl;

import earth.terrarium.common_storage_lib.resources.Resource;
import earth.terrarium.common_storage_lib.resources.ResourceStack;
import earth.terrarium.common_storage_lib.resources.item.ItemResource;
import earth.terrarium.common_storage_lib.storage.base.StorageSlot;
import earth.terrarium.common_storage_lib.storage.base.UpdateManager;
import earth.terrarium.common_storage_lib.storage.util.ModifiableItemSlot;
import java.util.function.Predicate;
import net.minecraft.class_1799;

public class SimpleItemSlot
implements StorageSlot<ItemResource>,
ModifiableItemSlot,
UpdateManager<ResourceStack<ItemResource>> {
    private final Runnable update;
    private final Runnable save;
    private ItemResource resource;
    private long amount;

    public SimpleItemSlot(Runnable update, Runnable save) {
        this.resource = ItemResource.BLANK;
        this.amount = this.getAmount();
        this.update = update;
        this.save = save;
    }

    public SimpleItemSlot(Runnable update) {
        this(update, () -> {});
    }

    public SimpleItemSlot(class_1799 stack) {
        this.resource = ItemResource.of((class_1799)stack);
        this.amount = stack.method_7947();
        this.update = () -> {};
        this.save = () -> {};
    }

    @Override
    public long getLimit(ItemResource resource) {
        return resource.isBlank() ? 99L : (long)resource.getCachedStack().method_7914();
    }

    @Override
    public boolean isResourceValid(ItemResource resource) {
        return true;
    }

    @Override
    public ItemResource getResource() {
        return this.resource;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    public void set(ItemResource resource, long amount) {
        this.resource = resource;
        this.amount = amount;
    }

    @Override
    public void set(ResourceStack<ItemResource> data) {
        this.resource = (ItemResource)data.resource();
        this.amount = data.amount();
    }

    @Override
    public long insert(ItemResource resource, long amount, boolean simulate) {
        if (!this.isResourceValid(resource)) {
            return 0L;
        }
        if (this.resource.isBlank()) {
            long inserted = Math.min(amount, this.getLimit(resource));
            if (!simulate) {
                this.resource = resource;
                this.amount = inserted;
                this.save.run();
            }
            return inserted;
        }
        if (this.resource.equals((Object)resource)) {
            long inserted = Math.min(amount, this.getLimit(resource) - this.amount);
            if (!simulate) {
                this.amount += inserted;
                this.save.run();
            }
            return inserted;
        }
        return 0L;
    }

    @Override
    public long extract(ItemResource resource, long amount, boolean simulate) {
        if (this.resource.equals((Object)resource)) {
            long extracted = Math.min(amount, this.amount);
            if (!simulate) {
                this.amount -= extracted;
                if (this.amount == 0L) {
                    this.resource = ItemResource.BLANK;
                    this.save.run();
                }
            }
            return extracted;
        }
        return 0L;
    }

    @Override
    public ResourceStack<ItemResource> createSnapshot() {
        return new ResourceStack((Resource)this.resource, this.amount);
    }

    @Override
    public void readSnapshot(ResourceStack<ItemResource> snapshot) {
        this.resource = (ItemResource)snapshot.resource();
        this.amount = snapshot.amount();
    }

    @Override
    public void update() {
        this.update.run();
    }

    @Override
    public void setAmount(long amount) {
        this.amount = amount;
    }

    @Override
    public void setResource(ItemResource resource) {
        this.resource = resource;
    }

    @Override
    public class_1799 toItemStack() {
        return this.resource.toStack((int)this.amount);
    }

    @Override
    public int getMaxAllowed(ItemResource resource) {
        return resource.getCachedStack().method_7914();
    }

    @Override
    public boolean isEmpty() {
        return this.resource.isBlank() || this.amount == 0L;
    }

    public static class Filtered
    extends SimpleItemSlot {
        private final Predicate<ItemResource> filter;

        public Filtered(Runnable update, Predicate<ItemResource> filter) {
            super(update);
            this.filter = filter;
        }

        @Override
        public boolean isResourceValid(ItemResource resource) {
            return this.filter.test(resource);
        }
    }
}

