/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.item.impl;

import earth.terrarium.common_storage_lib.context.ItemContext;
import earth.terrarium.common_storage_lib.data.DataManager;
import earth.terrarium.common_storage_lib.item.impl.SimpleItemSlot;
import earth.terrarium.common_storage_lib.item.util.ItemStorageData;
import earth.terrarium.common_storage_lib.resources.item.ItemResource;
import earth.terrarium.common_storage_lib.storage.base.CommonStorage;
import earth.terrarium.common_storage_lib.storage.base.UpdateManager;
import earth.terrarium.common_storage_lib.storage.util.TransferUtil;
import java.util.function.Predicate;
import net.minecraft.class_2371;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;

public class SimpleItemStorage
implements CommonStorage<ItemResource>,
UpdateManager<ItemStorageData> {
    protected final class_2371<SimpleItemSlot> slots;
    private final Runnable onUpdate;
    private final Runnable save;

    public SimpleItemStorage(int size) {
        this.slots = class_2371.method_10213((int)size, (Object)new SimpleItemSlot(this::update));
        this.onUpdate = () -> {};
        this.save = () -> {};
    }

    public SimpleItemStorage(ItemContext context, class_9331<ItemStorageData> componentType, int size) {
        this.slots = class_2371.method_10213((int)size, (Object)new SimpleItemSlot(this::update));
        this.onUpdate = context::updateAll;
        this.save = () -> context.set(componentType, ItemStorageData.of(this));
        if (context.getResource().method_57826(componentType)) {
            this.readSnapshot((ItemStorageData)context.getResource().method_57824(componentType));
        }
    }

    public SimpleItemStorage(Object entityOrBlockEntity, DataManager<ItemStorageData> dataManager, int size) {
        this.slots = class_2371.method_10213((int)size, (Object)new SimpleItemSlot(this::update));
        this.onUpdate = () -> dataManager.set(entityOrBlockEntity, (Object)ItemStorageData.of(this));
        this.save = () -> {};
        this.readSnapshot((ItemStorageData)dataManager.get(entityOrBlockEntity));
    }

    public SimpleItemStorage filter(int slot, Predicate<ItemResource> predicate) {
        this.slots.set(slot, (Object)new SimpleItemSlot.Filtered(this::update, predicate));
        return this;
    }

    @Override
    public int size() {
        return this.slots.size();
    }

    @NotNull
    public SimpleItemSlot get(int index) {
        return (SimpleItemSlot)this.slots.get(index);
    }

    @Override
    public ItemStorageData createSnapshot() {
        return ItemStorageData.of(this);
    }

    @Override
    public void readSnapshot(ItemStorageData snapshot) {
        for (int i = 0; i < this.slots.size() && i < snapshot.stacks().size(); ++i) {
            ((SimpleItemSlot)this.slots.get(i)).readSnapshot(snapshot.stacks().get(i));
        }
    }

    @Override
    public void update() {
        this.onUpdate.run();
    }

    @Override
    public long insert(ItemResource resource, long amount, boolean simulate) {
        return TransferUtil.insertSlots(this, resource, amount, simulate);
    }

    @Override
    public long extract(ItemResource resource, long amount, boolean simulate) {
        return TransferUtil.extractSlots(this, resource, amount, simulate);
    }
}

