/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.item.impl.vanilla;

import earth.terrarium.common_storage_lib.item.impl.vanilla.AbstractVanillaContainer;
import earth.terrarium.common_storage_lib.resources.item.ItemResource;
import earth.terrarium.common_storage_lib.storage.base.StorageSlot;
import earth.terrarium.common_storage_lib.storage.base.UpdateManager;
import earth.terrarium.common_storage_lib.storage.util.TransferUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public class PlayerContainer
extends AbstractVanillaContainer
implements UpdateManager<InventoryState> {
    private final class_1661 inventory;
    private final List<class_1799> toDrop = new ArrayList<class_1799>();

    public PlayerContainer(class_1661 container) {
        super((class_1263)container);
        this.inventory = container;
    }

    @Override
    public long insert(ItemResource resource, long amount, boolean simulate) {
        return this.offer(resource, amount, simulate);
    }

    @Override
    public long extract(ItemResource resource, long amount, boolean simulate) {
        return 0L;
    }

    public long offer(ItemResource resource, long amount, boolean simulate) {
        long initialAmount = amount;
        for (class_1268 hand : class_1268.values()) {
            StorageSlot<ItemResource> handSlot = this.getHandSlot(hand);
            if (!handSlot.getResource().equals((Object)resource) || (amount -= handSlot.insert(resource, amount, simulate)) != 0L) continue;
            return initialAmount;
        }
        amount -= TransferUtil.insertSubset(this, 0, 36, resource, amount, simulate);
        return initialAmount - amount;
    }

    public long offerOrDrop(ItemResource resource, long amount, boolean simulate) {
        long inserted = this.offer(resource, amount, simulate);
        if (inserted < amount) {
            this.drop(resource, amount - inserted, simulate);
        }
        return amount;
    }

    public void drop(ItemResource resource, long amount, boolean simulate) {
        if (!simulate) {
            int stackSize;
            class_1799 fakeStack = resource.toStack();
            for (long leftover = amount; leftover > 0L; leftover -= (long)stackSize) {
                stackSize = (int)Math.min(leftover, (long)fakeStack.method_7914());
                this.toDrop.add(resource.toStack(stackSize));
            }
        }
    }

    public StorageSlot<ItemResource> getHandSlot(class_1268 hand) {
        if (hand == class_1268.field_5808) {
            if (class_1661.method_7380((int)this.inventory.field_7545)) {
                return this.get(this.inventory.field_7545);
            }
            throw new IllegalArgumentException("Main hand is not a hotbar slot: " + this.inventory.field_7545);
        }
        if (hand == class_1268.field_5810) {
            return this.get(40);
        }
        throw new IllegalArgumentException("Invalid hand: " + String.valueOf(hand));
    }

    @Override
    public InventoryState createSnapshot() {
        class_2371 items = class_2371.method_10213((int)this.inventory.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            items.set(i, (Object)this.inventory.method_5438(i).method_7972());
        }
        return new InventoryState((class_2371<class_1799>)items, this.toDrop.size());
    }

    @Override
    public void readSnapshot(InventoryState snapshot) {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            this.inventory.method_5447(i, (class_1799)snapshot.items.get(i));
        }
        if (this.toDrop.size() > snapshot.droppedItemCount) {
            int previousSize = snapshot.droppedItemCount;
            while (this.toDrop.size() > previousSize) {
                this.toDrop.removeLast();
            }
        }
    }

    @Override
    public void update() {
        for (class_1799 stack : this.toDrop) {
            this.inventory.field_7546.method_7328(stack, false);
        }
        this.toDrop.clear();
    }

    public record InventoryState(class_2371<class_1799> items, int droppedItemCount) {
    }

    public static class AutoDrop
    extends PlayerContainer {
        public AutoDrop(class_1661 container) {
            super(container);
        }

        @Override
        public long insert(ItemResource resource, long amount, boolean simulate) {
            return this.offerOrDrop(resource, amount, simulate);
        }
    }
}

