/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.item.impl.vanilla;

import earth.terrarium.common_storage_lib.item.impl.vanilla.AbstractVanillaContainer;
import earth.terrarium.common_storage_lib.resources.item.ItemResource;
import earth.terrarium.common_storage_lib.storage.base.StorageSlot;
import earth.terrarium.common_storage_lib.storage.base.UpdateManager;
import net.minecraft.class_1263;
import net.minecraft.class_1799;

public class VanillaDelegatingSlot
implements StorageSlot<ItemResource>,
UpdateManager<class_1799> {
    private final int slot;
    private final class_1263 container;
    private final Runnable update;

    public VanillaDelegatingSlot(AbstractVanillaContainer container, int slot) {
        Runnable runnable;
        this.container = container.container;
        if (container instanceof UpdateManager) {
            UpdateManager manager = (UpdateManager)((Object)container);
            runnable = manager::update;
        } else {
            runnable = () -> {};
        }
        this.update = runnable;
        this.slot = slot;
    }

    @Override
    public long getLimit(ItemResource resource) {
        return this.container.method_58350(resource.getCachedStack());
    }

    @Override
    public boolean isResourceValid(ItemResource resource) {
        return this.container.method_5437(this.slot, resource.toStack());
    }

    @Override
    public ItemResource getResource() {
        return ItemResource.of((class_1799)this.container.method_5438(this.slot));
    }

    @Override
    public long getAmount() {
        return this.container.method_5438(this.slot).method_7947();
    }

    @Override
    public long insert(ItemResource resource, long amount, boolean simulate) {
        class_1799 stack = this.container.method_5438(this.slot);
        if (resource.test(stack) || stack.method_7960()) {
            if (stack.method_7960()) {
                class_1799 inserted = resource.toStack(Math.min((int)amount, (int)this.getLimit(resource)));
                if (!simulate) {
                    this.container.method_5447(this.slot, inserted);
                }
                return inserted.method_7947();
            }
            class_1799 inserted = resource.toStack(Math.min((int)amount + stack.method_7947(), (int)this.getLimit(resource)));
            if (!simulate) {
                this.container.method_5447(this.slot, inserted);
            }
            return inserted.method_7947() - stack.method_7947();
        }
        return 0L;
    }

    @Override
    public long extract(ItemResource resource, long amount, boolean simulate) {
        class_1799 stack = this.container.method_5438(this.slot).method_7972();
        if (resource.test(stack)) {
            class_1799 extracted = stack.method_7971((int)amount);
            if (!simulate) {
                if (stack.method_7960()) {
                    this.container.method_5447(this.slot, class_1799.field_8037);
                } else {
                    this.container.method_5447(this.slot, stack);
                }
            }
            return extracted.method_7947();
        }
        return 0L;
    }

    @Override
    public class_1799 createSnapshot() {
        return this.container.method_5438(this.slot).method_7972();
    }

    @Override
    public void readSnapshot(class_1799 snapshot) {
        this.container.method_5447(this.slot, snapshot);
    }

    @Override
    public void update() {
        this.update.run();
    }
}

