/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.item.input;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import earth.terrarium.common_storage_lib.item.input.ConsumerType;
import earth.terrarium.common_storage_lib.item.input.consumers.CompoundConsumer;
import earth.terrarium.common_storage_lib.item.input.consumers.EnergyConsumer;
import earth.terrarium.common_storage_lib.item.input.consumers.FluidConsumer;
import earth.terrarium.common_storage_lib.item.input.consumers.SizedConsumer;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_9139;

public class ItemConsumerRegistry {
    public static final Map<class_2960, ConsumerType<?>> CONSUMER_TYPES = new HashMap();
    public static final Codec<ConsumerType<?>> TYPE_CODEC = class_2960.field_25139.comapFlatMap(ItemConsumerRegistry::decode, ConsumerType::id);
    public static final class_9139<ByteBuf, ConsumerType<?>> STREAM_CODEC = class_2960.field_48267.method_56432(CONSUMER_TYPES::get, ConsumerType::id);

    public static void register(ConsumerType<?> type) {
        CONSUMER_TYPES.put(type.id(), type);
    }

    public static void init() {
    }

    private static DataResult<? extends ConsumerType<?>> decode(class_2960 id) {
        return Optional.ofNullable(CONSUMER_TYPES.get(id)).map(DataResult::success).orElse(DataResult.error(() -> "No ritual component type found."));
    }

    static {
        ItemConsumerRegistry.register(SizedConsumer.TYPE);
        ItemConsumerRegistry.register(CompoundConsumer.TYPE);
        ItemConsumerRegistry.register(EnergyConsumer.TYPE);
        ItemConsumerRegistry.register(FluidConsumer.TYPE);
    }
}

