/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.item.input.consumers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.common_storage_lib.context.ItemContext;
import earth.terrarium.common_storage_lib.fluid.FluidApi;
import earth.terrarium.common_storage_lib.item.input.ConsumerType;
import earth.terrarium.common_storage_lib.item.input.ItemConsumer;
import earth.terrarium.common_storage_lib.resources.fluid.ingredient.SizedFluidIngredient;
import earth.terrarium.common_storage_lib.storage.base.CommonStorage;
import earth.terrarium.common_storage_lib.storage.util.TransferUtil;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8824;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public record FluidConsumer(SizedFluidIngredient ingredient, class_2561 name) implements ItemConsumer
{
    public static final MapCodec<FluidConsumer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedFluidIngredient.FLAT_MB_CODEC.forGetter(FluidConsumer::ingredient), (App)class_8824.field_46597.fieldOf("name").forGetter(FluidConsumer::name)).apply((Applicative)instance, FluidConsumer::new));
    public static final ConsumerType<FluidConsumer> TYPE = new ConsumerType<FluidConsumer>(class_2960.method_60655((String)"common_storage_lib", (String)"fluid"), CODEC);

    @Override
    public boolean test(class_1799 stack, ItemContext context) {
        CommonStorage storage = (CommonStorage)FluidApi.ITEM.find(stack, (Object)context);
        return storage != null && TransferUtil.extractFluid(storage, this.ingredient, true).amount() > this.ingredient.getAmount();
    }

    @Override
    public void consume(class_1799 stack, ItemContext context) {
        CommonStorage storage = (CommonStorage)FluidApi.ITEM.find(stack, (Object)context);
        TransferUtil.extractFluid(storage, this.ingredient, false);
    }

    @Override
    public class_1799 modifyDisplay(class_1799 stack) {
        class_9290 lore = (class_9290)stack.method_57825(class_9334.field_49632, (Object)class_9290.field_49340);
        lore = lore.method_57499((class_2561)class_2561.method_43469((String)"misc.common_storage_lib.consume", (Object[])new Object[]{class_2561.method_43469((String)"misc.common_storage_lib.fluid", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(this.ingredient.getAmountAsMb())), this.name}).method_27692(class_124.field_1075)}).method_27692(class_124.field_1080));
        stack.method_57379(class_9334.field_49632, (Object)lore);
        return stack;
    }

    @Override
    public ConsumerType<?> getType() {
        return null;
    }
}

