/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.item.input.consumers;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import earth.terrarium.common_storage_lib.context.ItemContext;
import earth.terrarium.common_storage_lib.item.input.ConsumerType;
import earth.terrarium.common_storage_lib.item.input.ItemConsumer;
import earth.terrarium.common_storage_lib.resources.item.ItemResource;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public record SizedConsumer(long amount) implements ItemConsumer
{
    public static final SizedConsumer DEFAULT = new SizedConsumer(1L);
    public static final Codec<SizedConsumer> CODEC = Codec.LONG.xmap(SizedConsumer::new, SizedConsumer::amount);
    public static final MapCodec<SizedConsumer> MAP_CODEC = CODEC.optionalFieldOf("count", (Object)DEFAULT);
    public static final ConsumerType<SizedConsumer> TYPE = new ConsumerType<SizedConsumer>(class_2960.method_60655((String)"common_storage_lib", (String)"sized"), MAP_CODEC);

    @Override
    public boolean test(class_1799 stack, ItemContext context) {
        if ((long)stack.method_7947() < this.amount) {
            return false;
        }
        if (context.getResource().hasCraftingRemainder()) {
            ItemResource remaining = context.getResource().getCraftingRemainder();
            long exchanged = context.exchange(remaining, this.amount, true);
            return exchanged == this.amount;
        }
        return true;
    }

    @Override
    public void consume(class_1799 stack, ItemContext context) {
        if (context.getResource().hasCraftingRemainder()) {
            ItemResource remaining = context.getResource().getCraftingRemainder();
            context.exchange(remaining, stack.method_7947(), false);
        } else {
            context.extract(context.getResource(), this.amount, false);
        }
    }

    @Override
    public class_1799 modifyDisplay(class_1799 stack) {
        return stack.method_46651((int)this.amount);
    }

    @Override
    public ConsumerType<?> getType() {
        return TYPE;
    }
}

