/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.storage.base;

import earth.terrarium.common_storage_lib.resources.Resource;
import earth.terrarium.common_storage_lib.resources.ResourceStack;
import earth.terrarium.common_storage_lib.storage.base.StorageIO;
import earth.terrarium.common_storage_lib.storage.base.StorageSlot;
import org.jetbrains.annotations.NotNull;

public interface CommonStorage<T extends Resource>
extends StorageIO<T> {
    public int size();

    @NotNull
    public StorageSlot<T> get(int var1);

    default public boolean allowsInsertion() {
        return true;
    }

    default public boolean allowsExtraction() {
        return true;
    }

    default public long getLimit(int index, T resource) {
        return this.get(index).getLimit(resource);
    }

    default public T getResource(int index) {
        return this.get(index).getResource();
    }

    default public ResourceStack<T> getContents(int index) {
        return this.get(index).getContents();
    }

    default public boolean isResourceValid(int index, T resource) {
        return this.get(index).isResourceValid(resource);
    }

    default public long getAmount(int index) {
        return this.get(index).getAmount();
    }

    default public long insert(int index, T resource, long amount, boolean simulate) {
        return this.get(index).insert(resource, amount, simulate);
    }

    default public long extract(int index, T resource, long amount, boolean simulate) {
        return this.get(index).extract(resource, amount, simulate);
    }

    public static <T extends Resource> Class<CommonStorage<T>> asClass() {
        return CommonStorage.class;
    }
}

