/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.storage.common;

import earth.terrarium.common_storage_lib.storage.ConversionUtils;
import earth.terrarium.common_storage_lib.storage.base.ValueStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import team.reborn.energy.api.EnergyStorage;

public record CommonValueStorage(EnergyStorage storage) implements ValueStorage
{
    @Override
    public long getStoredAmount() {
        return this.storage.getAmount();
    }

    @Override
    public long getCapacity() {
        return this.storage.getCapacity();
    }

    @Override
    public boolean allowsInsertion() {
        return this.storage.supportsInsertion();
    }

    @Override
    public boolean allowsExtraction() {
        return this.storage.supportsExtraction();
    }

    @Override
    public long insert(long amount, boolean simulate) {
        try (Transaction transaction = ConversionUtils.getTransaction();){
            long inserted = this.storage.insert(amount, (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            long l = inserted;
            return l;
        }
    }

    @Override
    public long extract(long amount, boolean simulate) {
        try (Transaction transaction = ConversionUtils.getTransaction();){
            long extracted = this.storage.extract(amount, (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            long l = extracted;
            return l;
        }
    }
}

