/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.storage.common;

import earth.terrarium.common_storage_lib.resources.Resource;
import earth.terrarium.common_storage_lib.storage.ConversionUtils;
import earth.terrarium.common_storage_lib.storage.base.CommonStorage;
import earth.terrarium.common_storage_lib.storage.base.StorageSlot;
import earth.terrarium.common_storage_lib.storage.common.CommonWrappedSlotSlot;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;

public record CommonWrappedContainer<U extends Resource, V extends TransferVariant<?>>(Storage<V> storage, Function<U, V> toVariant, Function<V, U> toResource) implements CommonStorage<U>
{
    public U toResource(V variant) {
        return (U)((Resource)this.toResource.apply(variant));
    }

    public V toVariant(U resource) {
        return (V)((TransferVariant)this.toVariant.apply(resource));
    }

    @Override
    public int size() {
        if (this.storage instanceof SlottedStorage) {
            return ((SlottedStorage)this.storage).getSlotCount();
        }
        int count = 0;
        for (StorageView ignored : this.storage) {
            ++count;
        }
        return count;
    }

    @Override
    @NotNull
    public StorageSlot<U> get(int index) {
        Storage<V> storage = this.storage;
        if (storage instanceof SlottedStorage) {
            SlottedStorage slotted = (SlottedStorage)storage;
            return new CommonWrappedSlotSlot<Resource, TransferVariant>((StorageView<TransferVariant>)slotted.getSlot(index), this::toVariant, this::toResource);
        }
        int i = 0;
        for (StorageView view : this.storage) {
            if (i == index) {
                return new CommonWrappedSlotSlot<Resource, TransferVariant>(view, this::toVariant, this::toResource);
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long insert(U resource, long amount, boolean simulate) {
        try (Transaction transaction = ConversionUtils.getTransaction();){
            long inserted = this.storage.insert(this.toVariant(resource), amount, (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            long l = inserted;
            return l;
        }
    }

    @Override
    public long extract(U resource, long amount, boolean simulate) {
        try (Transaction transaction = ConversionUtils.getTransaction();){
            long extracted = this.storage.extract(this.toVariant(resource), amount, (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            long l = extracted;
            return l;
        }
    }
}

