/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.storage.common;

import earth.terrarium.common_storage_lib.resources.Resource;
import earth.terrarium.common_storage_lib.storage.ConversionUtils;
import earth.terrarium.common_storage_lib.storage.base.StorageSlot;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public record CommonWrappedSlotSlot<U extends Resource, V extends TransferVariant<?>>(StorageView<V> view, Function<U, V> toVariant, Function<V, U> toresource) implements StorageSlot<U>
{
    @Override
    public long getLimit(U resource) {
        return this.view.getCapacity();
    }

    @Override
    public boolean isResourceValid(U value) {
        return true;
    }

    @Override
    public long insert(U value, long amount, boolean simulate) {
        StorageView<V> storageView = this.view;
        if (storageView instanceof SingleSlotStorage) {
            SingleSlotStorage slot = (SingleSlotStorage)storageView;
            try (Transaction transaction = ConversionUtils.getTransaction();){
                long inserted = slot.insert((Object)((TransferVariant)this.toVariant.apply(value)), amount, (TransactionContext)transaction);
                if (!simulate) {
                    transaction.commit();
                }
                long l = inserted;
                return l;
            }
        }
        return 0L;
    }

    @Override
    public long extract(U resource, long amount, boolean simulate) {
        try (Transaction transaction = ConversionUtils.getTransaction();){
            long extracted = this.view.extract((Object)((TransferVariant)this.toVariant.apply(resource)), amount, (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            long l = extracted;
            return l;
        }
    }

    @Override
    public U getResource() {
        return (U)((Resource)this.toresource.apply((TransferVariant)this.view.getResource()));
    }

    @Override
    public long getAmount() {
        return this.view.getAmount();
    }
}

