/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.storage.context;

import earth.terrarium.common_storage_lib.context.ItemContext;
import earth.terrarium.common_storage_lib.resources.item.ItemResource;
import earth.terrarium.common_storage_lib.storage.ConversionUtils;
import earth.terrarium.common_storage_lib.storage.base.CommonStorage;
import earth.terrarium.common_storage_lib.storage.base.StorageSlot;
import earth.terrarium.common_storage_lib.storage.common.CommonWrappedSlotSlot;
import earth.terrarium.common_storage_lib.storage.context.ContextItemContainer;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.apache.commons.lang3.function.TriFunction;

public record CommonItemContext(ContainerItemContext context) implements ItemContext
{
    @Override
    public long insert(ItemResource resource, long amount, boolean simulate) {
        try (Transaction transaction = ConversionUtils.getTransaction();){
            long inserted = this.context.insert(ConversionUtils.toVariant(resource), amount, (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            long l = inserted;
            return l;
        }
    }

    @Override
    public long extract(ItemResource resource, long amount, boolean simulate) {
        try (Transaction transaction = ConversionUtils.getTransaction();){
            long extracted = this.context.extract(ConversionUtils.toVariant(resource), amount, (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            long l = extracted;
            return l;
        }
    }

    @Override
    public long exchange(ItemResource newResource, long amount, boolean simulate) {
        try (Transaction transaction = ConversionUtils.getTransaction();){
            long exchanged = this.context.exchange(ConversionUtils.toVariant(newResource), amount, (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            long l = exchanged;
            return l;
        }
    }

    @Override
    public CommonStorage<ItemResource> outerContainer() {
        return new ContextItemContainer(this.context.getAdditionalSlots(), (TriFunction<ItemVariant, Long, TransactionContext, Long>)((TriFunction)(arg_0, arg_1, arg_2) -> ((ContainerItemContext)this.context).insertOverflow(arg_0, arg_1, arg_2)));
    }

    @Override
    public StorageSlot<ItemResource> mainSlot() {
        return new CommonWrappedSlotSlot<ItemResource, ItemVariant>((StorageView<ItemVariant>)this.context.getMainSlot(), ConversionUtils::toVariant, ConversionUtils::toResource);
    }
}

