/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.storage.context;

import earth.terrarium.common_storage_lib.resources.item.ItemResource;
import earth.terrarium.common_storage_lib.storage.ConversionUtils;
import earth.terrarium.common_storage_lib.storage.base.CommonStorage;
import earth.terrarium.common_storage_lib.storage.base.StorageSlot;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public record ContextItemContainer(List<SingleSlotStorage<ItemVariant>> storage, TriFunction<ItemVariant, Long, TransactionContext, Long> insert) implements CommonStorage<ItemResource>
{
    @Override
    public int size() {
        return this.storage.size();
    }

    @Override
    @NotNull
    public StorageSlot<ItemResource> get(int index) {
        return new StorageSlotImpl(this.storage.get(index));
    }

    @Override
    public long insert(ItemResource resource, long amount, boolean simulate) {
        try (Transaction transaction = ConversionUtils.getTransaction();){
            long inserted = (Long)this.insert.apply((Object)ConversionUtils.toVariant(resource), (Object)amount, (Object)transaction);
            if (!simulate) {
                transaction.commit();
            }
            long l = inserted;
            return l;
        }
    }

    @Override
    public long extract(ItemResource predicate, long amount, boolean simulate) {
        long leftover = amount;
        ItemVariant variant = ConversionUtils.toVariant(predicate);
        try (Transaction transaction = ConversionUtils.getTransaction();){
            SingleSlotStorage<ItemVariant> view;
            long extractedAmount;
            Iterator<SingleSlotStorage<ItemVariant>> iterator = this.storage.iterator();
            while (iterator.hasNext() && (leftover -= (extractedAmount = (view = iterator.next()).extract((Object)variant, leftover, (TransactionContext)transaction))) > 0L) {
            }
            if (!simulate) {
                transaction.commit();
            }
        }
        return amount - leftover;
    }

    public record StorageSlotImpl(SingleSlotStorage<ItemVariant> storage) implements StorageSlot<ItemResource>
    {
        @Override
        public long getLimit(ItemResource resource) {
            return this.storage.getCapacity();
        }

        @Override
        public boolean isResourceValid(ItemResource value) {
            return true;
        }

        @Override
        public long insert(ItemResource resource, long amount, boolean simulate) {
            try (Transaction transaction = ConversionUtils.getTransaction();){
                long inserted = this.storage.insert((Object)ConversionUtils.toVariant(resource), amount, (TransactionContext)transaction);
                if (!simulate) {
                    transaction.commit();
                }
                long l = inserted;
                return l;
            }
        }

        @Override
        public long extract(ItemResource resource, long amount, boolean simulate) {
            try (Transaction transaction = ConversionUtils.getTransaction();){
                long extracted = this.storage.extract((Object)ConversionUtils.toVariant(resource), amount, (TransactionContext)transaction);
                if (!simulate) {
                    transaction.commit();
                }
                long l = extracted;
                return l;
            }
        }

        @Override
        public ItemResource getResource() {
            return ConversionUtils.toResource((ItemVariant)this.storage.getResource());
        }

        @Override
        public long getAmount() {
            return this.storage.getAmount();
        }
    }
}

