/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.storage.fabric;

import earth.terrarium.common_storage_lib.resources.Resource;
import earth.terrarium.common_storage_lib.resources.fluid.FluidResource;
import earth.terrarium.common_storage_lib.resources.item.ItemResource;
import earth.terrarium.common_storage_lib.storage.ConversionUtils;
import earth.terrarium.common_storage_lib.storage.base.CommonStorage;
import earth.terrarium.common_storage_lib.storage.base.StorageSlot;
import earth.terrarium.common_storage_lib.storage.fabric.FabricWrappedSlot;
import earth.terrarium.common_storage_lib.storage.fabric.OptionalSnapshotParticipant;
import java.util.Iterator;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;

public class FabricWrappedContainer<U extends Resource, V extends TransferVariant<?>>
implements SlottedStorage<V> {
    private final CommonStorage<U> container;
    private final OptionalSnapshotParticipant<?> updateManager;
    private final Function<U, V> toVariant;
    private final Function<V, U> toResource;

    public FabricWrappedContainer(CommonStorage<U> container, OptionalSnapshotParticipant<?> updateManager, Function<U, V> toVariant, Function<V, U> toResource) {
        this.container = container;
        this.updateManager = updateManager;
        this.toVariant = toVariant;
        this.toResource = toResource;
    }

    public FabricWrappedContainer(CommonStorage<U> container, Function<U, V> toVariant, Function<V, U> toResource) {
        this(container, OptionalSnapshotParticipant.of(container), toVariant, toResource);
    }

    public U toResource(V variant) {
        return (U)((Resource)this.toResource.apply(variant));
    }

    public V toVariant(U resource) {
        return (V)((TransferVariant)this.toVariant.apply(resource));
    }

    public long insert(V resource, long maxAmount, TransactionContext transaction) {
        U holder = this.toResource(resource);
        this.updateSnapshots(transaction);
        return this.container.insert(holder, maxAmount, false);
    }

    public long extract(V resource, long maxAmount, TransactionContext transaction) {
        U holder = this.toResource(resource);
        this.updateSnapshots(transaction);
        return this.container.extract(holder, maxAmount, false);
    }

    @NotNull
    public Iterator<StorageView<V>> iterator() {
        return new Iterator<StorageView<V>>(){
            int slot = 0;

            @Override
            public boolean hasNext() {
                return this.slot < FabricWrappedContainer.this.container.size();
            }

            @Override
            public StorageView<V> next() {
                return FabricWrappedContainer.this.getSlot(this.slot++);
            }
        };
    }

    public int getSlotCount() {
        return this.container.size();
    }

    public SingleSlotStorage<V> getSlot(int slot) {
        StorageSlot<U> storageSlot = this.container.get(slot);
        return new FabricWrappedSlot<Resource, TransferVariant>(storageSlot, this::toVariant, this::toResource);
    }

    private void updateSnapshots(TransactionContext transaction) {
        if (this.updateManager != null) {
            this.updateManager.updateSnapshots(transaction);
        }
    }

    public CommonStorage<U> container() {
        return this.container;
    }

    public OptionalSnapshotParticipant<?> updateManager() {
        return this.updateManager;
    }

    public static class OfItem
    extends FabricWrappedContainer<ItemResource, ItemVariant> {
        public OfItem(CommonStorage<ItemResource> container) {
            super(container, ConversionUtils::toVariant, ConversionUtils::toResource);
        }
    }

    public static class OfFluid
    extends FabricWrappedContainer<FluidResource, FluidVariant> {
        public OfFluid(CommonStorage<FluidResource> container) {
            super(container, ConversionUtils::toVariant, ConversionUtils::toResource);
        }
    }
}

