/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.storage.fabric;

import earth.terrarium.common_storage_lib.resources.Resource;
import earth.terrarium.common_storage_lib.storage.base.StorageSlot;
import earth.terrarium.common_storage_lib.storage.fabric.OptionalSnapshotParticipant;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public record FabricWrappedSlot<U extends Resource, V extends TransferVariant<?>>(StorageSlot<U> container, @Nullable OptionalSnapshotParticipant<?> updateManager, Function<V, U> toResource, Function<U, V> toVariant) implements SingleSlotStorage<V>
{
    public FabricWrappedSlot(StorageSlot<U> container, Function<U, V> toVariant, Function<V, U> toresource) {
        this(container, OptionalSnapshotParticipant.of(container), toresource, toVariant);
    }

    public long insert(V resource, long maxAmount, TransactionContext transaction) {
        Resource holder = (Resource)this.toResource.apply(resource);
        this.updateSnapshots(transaction);
        return this.container.insert(holder, maxAmount, false);
    }

    public long extract(V resource, long maxAmount, TransactionContext transaction) {
        Resource holder = (Resource)this.toResource.apply(resource);
        this.updateSnapshots(transaction);
        return this.container.extract(holder, maxAmount, false);
    }

    public boolean isResourceBlank() {
        return this.container.getResource().isBlank();
    }

    public V getResource() {
        return (V)((TransferVariant)this.toVariant.apply(this.container.getResource()));
    }

    public long getAmount() {
        return this.container.getAmount();
    }

    public long getCapacity() {
        return this.container.getLimit(this.container.getResource());
    }

    private void updateSnapshots(TransactionContext transaction) {
        if (this.updateManager != null) {
            this.updateManager.updateSnapshots(transaction);
        }
    }
}

