/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.storage.impl;

import earth.terrarium.common_storage_lib.resources.Resource;
import earth.terrarium.common_storage_lib.storage.base.CommonStorage;
import earth.terrarium.common_storage_lib.storage.base.StorageSlot;
import earth.terrarium.common_storage_lib.storage.base.UpdateManager;
import org.jetbrains.annotations.NotNull;

public class AggregateContainer<T extends Resource>
implements CommonStorage<T>,
UpdateManager<Object[]> {
    private final CommonStorage<T>[] containers;
    private final int[] indexOffsets;
    private final int slotCount;

    @SafeVarargs
    public AggregateContainer(CommonStorage<T> ... containers) {
        this.containers = containers;
        this.indexOffsets = new int[containers.length];
        int index = 0;
        for (int i = 0; i < this.indexOffsets.length; ++i) {
            this.indexOffsets[i] = index += containers[i].size();
        }
        this.slotCount = index;
    }

    @Override
    public int size() {
        return this.slotCount;
    }

    @Override
    @NotNull
    public StorageSlot<T> get(int index) {
        for (int i = 0; i < this.containers.length; ++i) {
            if (index >= this.indexOffsets[i]) continue;
            return this.containers[i].get(index - this.indexOffsets[i]);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long insert(T resource, long amount, boolean simulate) {
        long inserted = 0L;
        for (CommonStorage<T> container : this.containers) {
            if ((inserted += container.insert(resource, amount - inserted, simulate)) >= amount) break;
        }
        return inserted;
    }

    @Override
    public long extract(T resource, long amount, boolean simulate) {
        long extracted = 0L;
        for (CommonStorage<T> container : this.containers) {
            if ((extracted += container.extract(resource, amount - extracted, simulate)) >= amount) break;
        }
        return extracted;
    }

    @Override
    public Object[] createSnapshot() {
        Object[] snapshots = new Object[this.containers.length];
        for (int i = 0; i < this.containers.length; ++i) {
            if (!(this.containers[i] instanceof UpdateManager)) continue;
            snapshots[i] = ((UpdateManager)((Object)this.containers[i])).createSnapshot();
        }
        return snapshots;
    }

    @Override
    public void readSnapshot(Object[] snapshot) {
        for (int i = 0; i < this.containers.length; ++i) {
            CommonStorage<T> commonStorage = this.containers[i];
            if (!(commonStorage instanceof UpdateManager)) continue;
            UpdateManager manager = (UpdateManager)((Object)commonStorage);
            UpdateManager.forceRead(manager, snapshot[i]);
        }
    }

    @Override
    public void update() {
        UpdateManager.batch(this.containers);
    }
}

