/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.storage.util;

import earth.terrarium.common_storage_lib.resources.Resource;
import earth.terrarium.common_storage_lib.resources.ResourceStack;
import earth.terrarium.common_storage_lib.resources.fluid.FluidResource;
import earth.terrarium.common_storage_lib.resources.fluid.ingredient.SizedFluidIngredient;
import earth.terrarium.common_storage_lib.resources.item.ItemResource;
import earth.terrarium.common_storage_lib.storage.base.CommonStorage;
import earth.terrarium.common_storage_lib.storage.base.StorageIO;
import earth.terrarium.common_storage_lib.storage.base.StorageSlot;
import earth.terrarium.common_storage_lib.storage.base.UpdateManager;
import earth.terrarium.common_storage_lib.storage.base.ValueStorage;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class TransferUtil {
    public static <T extends Resource> Optional<T> findResource(CommonStorage<T> container, Predicate<T> predicate) {
        for (int i = 0; i < container.size(); ++i) {
            T resource;
            StorageSlot<T> slot = container.get(i);
            if (slot.getResource().isBlank() || !predicate.test(resource = slot.getResource())) continue;
            return Optional.of(resource);
        }
        return Optional.empty();
    }

    public static <T extends Resource> Optional<T> findFirstResource(CommonStorage<T> container) {
        return TransferUtil.findResource(container, resource -> true);
    }

    public static Predicate<ItemResource> byItemTag(class_6862<class_1792> tag) {
        return resource -> resource.is(tag);
    }

    public static Predicate<ItemResource> byIngredient(class_1856 ingredient) {
        return resource -> ingredient.method_8093(resource.getCachedStack());
    }

    public static Predicate<FluidResource> byFluidTag(class_6862<class_3611> tag) {
        return resource -> resource.is(tag);
    }

    public static <T> long move(StorageIO<T> from, StorageIO<T> to, T resource, long amount, boolean simulate) {
        long extracted = from.extract(resource, amount, true);
        long inserted = to.insert(resource, extracted, true);
        if (extracted > 0L && inserted > 0L) {
            if (inserted != extracted) {
                extracted = from.extract(resource, Math.min(extracted, inserted), true);
                inserted = to.insert(resource, Math.min(extracted, inserted), true);
            }
            if (extracted == inserted) {
                from.extract(resource, extracted, simulate);
                to.insert(resource, extracted, simulate);
                UpdateManager.batch(from, to);
                return extracted;
            }
        }
        return 0L;
    }

    public static <T extends Resource> class_3545<T, Long> moveFiltered(CommonStorage<T> from, StorageIO<T> to, Predicate<T> filter, long amount, boolean simulate) {
        Optional<T> optional = TransferUtil.findResource(from, filter);
        if (optional.isPresent()) {
            Resource resource = (Resource)optional.get();
            long moved = TransferUtil.move(from, to, resource, amount, simulate);
            return new class_3545((Object)resource, (Object)moved);
        }
        return new class_3545(null, (Object)0L);
    }

    public static <T extends Resource> class_3545<T, Long> moveAny(CommonStorage<T> from, StorageIO<T> to, long amount, boolean simulate) {
        for (int i = 0; i < from.size(); ++i) {
            T resource;
            long moved;
            StorageSlot<T> slot = from.get(i);
            if (slot.getResource().isBlank() || (moved = TransferUtil.move(from, to, resource = slot.getResource(), amount, simulate)) <= 0L) continue;
            return new class_3545(resource, (Object)moved);
        }
        return new class_3545(null, (Object)0L);
    }

    public static <T extends Resource> void moveAll(CommonStorage<T> from, StorageIO<T> to, boolean simulate) {
        for (int i = 0; i < from.size(); ++i) {
            StorageSlot<T> slot = from.get(i);
            if (slot.getResource().isBlank()) continue;
            T resource = slot.getResource();
            TransferUtil.move(from, to, resource, Long.MAX_VALUE, simulate);
        }
    }

    public static long moveValue(ValueStorage from, ValueStorage to, long amount, boolean simulate) {
        long extracted = from.extract(amount, true);
        long inserted = to.insert(extracted, true);
        if (extracted > 0L && inserted > 0L) {
            if (inserted != extracted) {
                extracted = from.extract(Math.min(extracted, inserted), true);
                inserted = to.insert(Math.min(extracted, inserted), true);
            }
            if (extracted == inserted) {
                from.extract(extracted, simulate);
                to.insert(extracted, simulate);
                UpdateManager.batch(from, to);
                return extracted;
            }
        }
        return 0L;
    }

    public static <T extends Resource> long exchange(StorageIO<T> io, T oldresource, T newresource, long amount, boolean simulate) {
        long extracted = io.extract(oldresource, amount, false);
        if (extracted > 0L) {
            long inserted = io.insert(newresource, extracted, true);
            if (extracted == inserted && !simulate) {
                io.insert(newresource, extracted, false);
            } else {
                io.insert(oldresource, extracted, false);
            }
            return extracted == inserted ? extracted : 0L;
        }
        return 0L;
    }

    public static <T extends Resource> long insertSlots(CommonStorage<T> container, T resource, long amount, boolean simulate) {
        return TransferUtil.insertSubset(container, 0, container.size(), resource, amount, simulate);
    }

    public static <T extends Resource> long insertSubset(CommonStorage<T> container, int start, int end, T resource, long amount, boolean simulate) {
        int i;
        long inserted = 0L;
        for (i = start; i < end; ++i) {
            StorageSlot<T> slot = container.get(i);
            if (slot.getResource().isBlank() || (inserted += slot.insert(resource, amount - inserted, simulate)) < amount) continue;
            return inserted;
        }
        for (i = start; i < end; ++i) {
            if ((inserted += container.get(i).insert(resource, amount - inserted, simulate)) < amount) continue;
            return inserted;
        }
        return inserted;
    }

    public static <T extends Resource> long extractSlots(CommonStorage<T> container, T resource, long amount, boolean simulate) {
        return TransferUtil.extractSubset(container, 0, container.size(), resource, amount, simulate);
    }

    public static <T extends Resource> long extractSubset(CommonStorage<T> container, int start, int end, T resource, long amount, boolean simulate) {
        long extracted = 0L;
        for (int i = start; i < end; ++i) {
            if ((extracted += container.get(i).extract(resource, amount - extracted, simulate)) < amount) continue;
            return extracted;
        }
        return extracted;
    }

    public static <T extends Resource> void equalize(StorageSlot<T> slot, long amount) {
        T resource = slot.getResource();
        long current = slot.getAmount();
        if (current < amount) {
            slot.insert(resource, amount - current, false);
        } else if (current > amount) {
            slot.extract(resource, current - amount, false);
        }
    }

    public static <T extends Resource> long insertStack(CommonStorage<T> container, ResourceStack<T> stack, boolean simulate) {
        return TransferUtil.insertSlots(container, stack.resource(), stack.amount(), simulate);
    }

    public static <T extends Resource> long extractStack(CommonStorage<T> container, ResourceStack<T> stack, boolean simulate) {
        return TransferUtil.extractSlots(container, stack.resource(), stack.amount(), simulate);
    }

    @Nullable
    public static <T extends Resource> ResourceStack<T> extractPredicate(CommonStorage<T> container, Predicate<T> predicate, long amount, boolean simulate) {
        HashSet<T> resources = new HashSet<T>();
        ResourceStack stack = null;
        for (int i = 0; i < container.size(); ++i) {
            T resource;
            StorageSlot<T> slot = container.get(i);
            if (slot.getResource().isBlank() || !predicate.test(resource = slot.getResource()) || resources.contains(resource)) continue;
            resources.add(resource);
            ResourceStack newStack = new ResourceStack(resource, slot.extract(resource, amount, simulate));
            if ((stack == null || newStack.amount() > stack.amount()) && (stack = newStack).amount() >= amount) break;
        }
        return stack;
    }

    public static ResourceStack<ItemResource> extractItem(CommonStorage<ItemResource> container, Predicate<ItemResource> predicate, long amount, boolean simulate) {
        return Optional.ofNullable(TransferUtil.extractPredicate(container, predicate, amount, simulate)).orElse((ResourceStack<ItemResource>)ResourceStack.EMPTY_ITEM);
    }

    public static ResourceStack<FluidResource> extractFluid(CommonStorage<FluidResource> container, Predicate<FluidResource> predicate, long amount, boolean simulate) {
        return Optional.ofNullable(TransferUtil.extractPredicate(container, predicate, amount, simulate)).orElse((ResourceStack<FluidResource>)ResourceStack.EMPTY_FLUID);
    }

    public static ResourceStack<FluidResource> extractFluid(CommonStorage<FluidResource> container, SizedFluidIngredient ingredient, boolean simulate) {
        return TransferUtil.extractFluid(container, (Predicate<FluidResource>)ingredient.ingredient(), ingredient.getAmount(), simulate);
    }
}

