/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.common_storage_lib.wrapped;

import earth.terrarium.common_storage_lib.context.ItemContext;
import earth.terrarium.common_storage_lib.lookup.ItemLookup;
import earth.terrarium.common_storage_lib.resources.Resource;
import earth.terrarium.common_storage_lib.resources.fluid.FluidResource;
import earth.terrarium.common_storage_lib.storage.ConversionUtils;
import earth.terrarium.common_storage_lib.storage.base.CommonStorage;
import earth.terrarium.common_storage_lib.storage.common.CommonWrappedContainer;
import earth.terrarium.common_storage_lib.storage.context.CommonItemContext;
import earth.terrarium.common_storage_lib.storage.context.FabricItemContext;
import earth.terrarium.common_storage_lib.storage.fabric.FabricWrappedContainer;
import earth.terrarium.common_storage_lib.storage.impl.AutoUpdatingCommonStorage;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.lookup.v1.item.ItemApiLookup;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import org.jetbrains.annotations.Nullable;

public abstract class WrappedItemLookup<U extends Resource, V extends TransferVariant<?>>
implements ItemLookup<CommonStorage<U>, ItemContext> {
    private final ItemApiLookup<Storage<V>, ContainerItemContext> fabricLookup;

    public WrappedItemLookup(ItemApiLookup<Storage<V>, ContainerItemContext> fabricLookup) {
        this.fabricLookup = fabricLookup;
    }

    public void onRegister(Consumer<ItemLookup.ItemRegistrar<CommonStorage<U>, ItemContext>> registrar) {
        registrar.accept(this::registerItems);
    }

    public void registerItems(ItemLookup.ItemGetter<CommonStorage<U>, ItemContext> getter, class_1792 ... items) {
        this.fabricLookup.registerForItems((stack, context) -> {
            CommonStorage container = (CommonStorage)getter.getContainer(stack, (Object)new CommonItemContext((ContainerItemContext)context));
            return container == null ? null : this.wrap(container);
        }, (class_1935[])items);
    }

    public void registerFallback(ItemLookup.ItemGetter<CommonStorage<U>, ItemContext> getter) {
        this.fabricLookup.registerFallback((stack, context) -> {
            CommonStorage container = (CommonStorage)getter.getContainer(stack, (Object)new CommonItemContext((ContainerItemContext)context));
            return container == null ? null : this.wrap(container);
        });
    }

    public void registerFallback(ItemLookup.ItemGetter<CommonStorage<U>, ItemContext> getter, Predicate<class_1792> itemPredicate) {
        this.registerFallback(getter);
    }

    public abstract FabricWrappedContainer<U, V> wrap(CommonStorage<U> var1);

    public ItemApiLookup<Storage<V>, ContainerItemContext> getFabricLookup() {
        return this.fabricLookup;
    }

    public static class OfFluid
    extends WrappedItemLookup<FluidResource, FluidVariant> {
        public OfFluid() {
            super(FluidStorage.ITEM);
        }

        @Override
        public FabricWrappedContainer<FluidResource, FluidVariant> wrap(CommonStorage<FluidResource> container) {
            return new FabricWrappedContainer.OfFluid(container);
        }

        @Nullable
        public CommonStorage<FluidResource> find(class_1799 stack, ItemContext context) {
            Storage storage = (Storage)this.getFabricLookup().find(stack, (Object)new FabricItemContext(context));
            if (storage != null) {
                if (storage instanceof FabricWrappedContainer.OfFluid) {
                    FabricWrappedContainer.OfFluid container = (FabricWrappedContainer.OfFluid)storage;
                    return new AutoUpdatingCommonStorage<FluidResource>(container.container());
                }
                return new CommonWrappedContainer<FluidResource, FluidVariant>(storage, ConversionUtils::toVariant, ConversionUtils::toResource);
            }
            return null;
        }
    }
}

