/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.client;

import java.util.List;
import net.luko.bestia.Bestia;
import net.luko.bestia.data.buff.special.SpecialBuffRegistry;
import net.luko.bestia.util.LevelFormula;
import net.minecraft.resources.ResourceLocation;

public class ClientConfigStore {
    public boolean enableSpecialBuffs;
    public int maxLevel;
    public String killsFormula;
    public double damageFactorPerLevel;
    public double resistanceFactorPerLevel;
    public int levelsPerSpecialBuffPoint;
    public int rerollMaxLevel;
    public int executeMaxLevel;
    public int lifestealMaxLevel;
    public int reflexMaxLevel;
    public int dazeMaxLevel;
    public double executeBuffPerLevel;
    public double lifestealBuffPerLevel;
    public double reflexBuffPerLevel;
    public int dazeBuffPerLevel;
    public int minLeaderboardLevel;
    public List<ResourceLocation> blacklistedEntities;
    public List<ResourceLocation> whitelistedEntities;
    public static ClientConfigStore INSTANCE = new ClientConfigStore();

    public static void sync(ClientConfigStore newStore) {
        Bestia.LOGGER.info("Common config sync was received, storing and reinitializing data...");
        INSTANCE = newStore;
        SpecialBuffRegistry.reinitializeForClient();
        LevelFormula.reinitializeForClient();
    }

    public boolean entityIsBlacklisted(ResourceLocation id) {
        return this.blacklistedEntities.contains(id);
    }

    public boolean entityIsWhitelisted(ResourceLocation id) {
        return this.whitelistedEntities.contains(id);
    }
}

