/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.luko.bestia.config.BestiaCommonConfig;
import net.luko.bestia.data.BestiaryManager;
import net.luko.bestia.data.PlayerBestiaryStore;
import net.luko.bestia.util.MobIdUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="bestia")
public class ModCommands {
    public static final SuggestionProvider<CommandSourceStack> ENTITY_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.m_82926_(ForgeRegistries.ENTITY_TYPES.getKeys().stream().filter(id -> MobIdUtil.validBestiaryMob(id, LogicalSide.SERVER)).toList(), (SuggestionsBuilder)builder);

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder bestiaryCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"bestiary").requires(source -> source.m_6761_(2));
        LiteralArgumentBuilder setLevel = (LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"level").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"mob", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ENTITY_SUGGESTIONS).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            ResourceLocation mobId = ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"mob");
            int level = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            return ModCommands.setBestiaryLevel((CommandSourceStack)ctx.getSource(), player, mobId, level);
        })))));
        LiteralArgumentBuilder setKills = (LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"kills").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"mob", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ENTITY_SUGGESTIONS).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            ResourceLocation mobId = ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"mob");
            int kills = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            return ModCommands.setBestiaryKills((CommandSourceStack)ctx.getSource(), player, mobId, kills);
        })))));
        LiteralArgumentBuilder addLevels = (LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"level").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"mob", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ENTITY_SUGGESTIONS).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            ResourceLocation mobId = ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"mob");
            int levels = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            return ModCommands.addBestiaryLevels((CommandSourceStack)ctx.getSource(), player, mobId, levels);
        })))));
        LiteralArgumentBuilder addKills = (LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"kills").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"mob", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ENTITY_SUGGESTIONS).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            ResourceLocation mobId = ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"mob");
            int kills = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            return ModCommands.addBestiaryKills((CommandSourceStack)ctx.getSource(), player, mobId, kills);
        })))));
        bestiaryCommand.then((ArgumentBuilder)setLevel);
        bestiaryCommand.then((ArgumentBuilder)setKills);
        bestiaryCommand.then((ArgumentBuilder)addLevels);
        bestiaryCommand.then((ArgumentBuilder)addKills);
        dispatcher.register(bestiaryCommand);
    }

    private static int setBestiaryLevel(CommandSourceStack source, ServerPlayer player, ResourceLocation mobId, int value) {
        if (value > (Integer)BestiaCommonConfig.MAX_LEVEL.get()) {
            source.m_81352_((Component)Component.m_237113_((String)"Level cannot exceed max level!"));
            return 0;
        }
        BestiaryManager manager = PlayerBestiaryStore.get(player);
        if (manager == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Could not get bestiary data for player."));
            return 0;
        }
        manager.setLevelAndSync(player, mobId, value);
        source.m_288197_(() -> Component.m_237113_((String)("Set " + String.valueOf(mobId) + " level to " + value + " for " + player.m_7755_().getString())), true);
        return 1;
    }

    private static int setBestiaryKills(CommandSourceStack source, ServerPlayer player, ResourceLocation mobId, int value) {
        BestiaryManager manager = PlayerBestiaryStore.get(player);
        if (manager == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Could not get bestiary data for player."));
            return 0;
        }
        manager.setKillsAndSync(player, mobId, value);
        source.m_288197_(() -> Component.m_237113_((String)("Set " + String.valueOf(mobId) + " kills to " + value + " for " + player.m_7755_().getString())), true);
        return 1;
    }

    private static int addBestiaryLevels(CommandSourceStack source, ServerPlayer player, ResourceLocation mobId, int value) {
        int current;
        if (value > (Integer)BestiaCommonConfig.MAX_LEVEL.get()) {
            source.m_81352_((Component)Component.m_237113_((String)"Level cannot exceed max level!"));
            return 0;
        }
        BestiaryManager manager = PlayerBestiaryStore.get(player);
        if (manager == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Could not get bestiary data for player."));
            return 0;
        }
        int n = current = manager.getData(mobId) == null ? 0 : manager.getData(mobId).level();
        if (current + value > (Integer)BestiaCommonConfig.MAX_LEVEL.get()) {
            source.m_81352_((Component)Component.m_237113_((String)"Level cannot exceed max level!"));
            return 0;
        }
        manager.addLevelsAndSync(player, mobId, value);
        source.m_288197_(() -> Component.m_237113_((String)("Added " + value + " level" + (value == 1 ? "" : "s") + " to " + String.valueOf(mobId) + " for " + player.m_7755_().getString())), true);
        return 1;
    }

    private static int addBestiaryKills(CommandSourceStack source, ServerPlayer player, ResourceLocation mobId, int value) {
        BestiaryManager manager = PlayerBestiaryStore.get(player);
        if (manager == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Could not get bestiary data for player."));
            return 0;
        }
        manager.addKillsAndSync(player, mobId, value);
        source.m_288197_(() -> Component.m_237113_((String)("Added " + value + " kill" + (value == 1 ? "" : "s") + " to " + String.valueOf(mobId) + " for " + player.m_7755_().getString())), true);
        return 1;
    }
}

