/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.luko.bestia.Bestia;
import net.luko.bestia.config.BestiaCommonConfig;
import net.luko.bestia.data.buff.MobBuff;
import net.luko.bestia.data.buff.special.SpecialBuffRegistry;
import net.luko.bestia.util.LevelFormula;
import net.minecraft.resources.ResourceLocation;

public record BestiaryData(int kills, int level, int remainingKills, MobBuff mobBuff, int totalPoints, int remainingPoints, Map<ResourceLocation, Integer> spentPoints) {
    public int neededForNextLevel() {
        return this.level == (Integer)BestiaCommonConfig.MAX_LEVEL.get() ? 0 : LevelFormula.getKills(this.level + 1) - LevelFormula.getKills(this.level);
    }

    public static int totalNeededForLevel(int level) {
        return LevelFormula.getKills(level);
    }

    public static BestiaryData compute(int kills, Map<ResourceLocation, Integer> spentPoints) {
        int totalPoints;
        int level = Math.min(LevelFormula.getLevel(kills), (Integer)BestiaCommonConfig.MAX_LEVEL.get());
        int remainingKills = LevelFormula.getKills(level + 1) - kills;
        float perLevelDamage = ((Double)BestiaCommonConfig.DAMAGE_FACTOR_PER_LEVEL.get()).floatValue();
        float damageFactor = 1.0f + perLevelDamage * (float)level;
        float perLevelResistance = ((Double)BestiaCommonConfig.RESISTANCE_FACTOR_PER_LEVEL.get()).floatValue();
        float resistanceFactor = (float)Math.pow(perLevelResistance, level);
        MobBuff mobBuff = new MobBuff(damageFactor, resistanceFactor);
        int levelsPerPoint = (Integer)BestiaCommonConfig.LEVELS_PER_SPECIAL_BUFF_POINT.get();
        int remainingPoints = totalPoints = level / levelsPerPoint;
        ArrayList<ResourceLocation> invalidKeys = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, Integer> entry : spentPoints.entrySet()) {
            if (SpecialBuffRegistry.get(entry.getKey()) == null) {
                Bestia.LOGGER.warn("Could not find {} in the Special Buff Registry, removing spent points...", (Object)entry.getKey());
                invalidKeys.add(entry.getKey());
                continue;
            }
            remainingPoints -= entry.getValue().intValue();
        }
        for (ResourceLocation resourceLocation : invalidKeys) {
            spentPoints.remove(resourceLocation);
        }
        if (remainingPoints < 0) {
            spentPoints = new HashMap<ResourceLocation, Integer>();
            remainingPoints = totalPoints;
        }
        for (Map.Entry<Object, Integer> entry : spentPoints.entrySet()) {
            int max = SpecialBuffRegistry.get((ResourceLocation)entry.getKey()).getMaxLevel();
            if (entry.getValue() <= max) continue;
            remainingPoints += entry.getValue() - max;
            spentPoints.put((ResourceLocation)entry.getKey(), max);
        }
        return new BestiaryData(kills, level, remainingKills, mobBuff, totalPoints, remainingPoints, spentPoints);
    }
}

