/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.data.buff.special;

import net.luko.bestia.data.buff.special.SpecialBuff;
import net.minecraft.resources.ResourceLocation;

public class FloatBuff
extends SpecialBuff<Float> {
    protected final float increment;
    protected final boolean displayAsPercent;

    public FloatBuff(ResourceLocation id, float defaultValue, float increment, int maxLevel, boolean displayAsPercent) {
        super(id, Float.valueOf(defaultValue), maxLevel);
        this.increment = increment;
        this.displayAsPercent = displayAsPercent;
    }

    @Override
    public Float computeValue(int level) {
        return Float.valueOf(((Float)this.defaultValue).floatValue() + this.increment * (float)level);
    }

    @Override
    public String getInfo(int level) {
        String baseInfo = this.getBaseInfo(level);
        if (level == 0) {
            return baseInfo;
        }
        return String.format(baseInfo, this.displayAsPercent ? String.format("%.1f", Float.valueOf(this.computeValue(level).floatValue() * 100.0f)) : String.format("%.3f", this.computeValue(level)));
    }
}

