/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.data.buff.special;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.luko.bestia.client.ClientConfigStore;
import net.luko.bestia.config.BestiaCommonConfig;
import net.luko.bestia.data.buff.special.BooleanBuff;
import net.luko.bestia.data.buff.special.FloatBuff;
import net.luko.bestia.data.buff.special.IntegerBuff;
import net.luko.bestia.data.buff.special.SpecialBuff;
import net.luko.bestia.util.ResourceUtil;
import net.minecraft.resources.ResourceLocation;

public class SpecialBuffRegistry {
    private static final Map<ResourceLocation, SpecialBuff<?>> BUFFS = new HashMap();
    public static SpecialBuff<Integer> REROLL;
    public static SpecialBuff<Float> EXECUTE;
    public static SpecialBuff<Float> LIFESTEAL;
    public static SpecialBuff<Float> REFLEX;
    public static SpecialBuff<Integer> DAZE;
    public static SpecialBuff<Boolean> HOLD;

    public static void init() {
        int rerollMax = (Integer)BestiaCommonConfig.REROLL_MAX_LEVEL.get();
        int executeMax = (Integer)BestiaCommonConfig.EXECUTE_MAX_LEVEL.get();
        int lifestealMax = (Integer)BestiaCommonConfig.LIFESTEAL_MAX_LEVEL.get();
        int reflexMax = (Integer)BestiaCommonConfig.REFLEX_MAX_LEVEL.get();
        int dazeMax = (Integer)BestiaCommonConfig.DAZE_MAX_LEVEL.get();
        float executeBuff = ((Double)BestiaCommonConfig.EXECUTE_BUFF_PER_LEVEL.get()).floatValue();
        float lifestealBuff = ((Double)BestiaCommonConfig.LIFESTEAL_BUFF_PER_LEVEL.get()).floatValue();
        float reflexBuff = ((Double)BestiaCommonConfig.REFLEX_BUFF_PER_LEVEL.get()).floatValue();
        int dazeBuff = (Integer)BestiaCommonConfig.DAZE_BUFF_PER_LEVEL.get();
        REROLL = SpecialBuffRegistry.register(new IntegerBuff(ResourceUtil.fromNamespaceAndPath("bestia", "reroll"), 0, 1, rerollMax));
        EXECUTE = SpecialBuffRegistry.register(new FloatBuff(ResourceUtil.fromNamespaceAndPath("bestia", "execute"), 0.0f, executeBuff, executeMax, true));
        LIFESTEAL = SpecialBuffRegistry.register(new FloatBuff(ResourceUtil.fromNamespaceAndPath("bestia", "lifesteal"), 0.0f, lifestealBuff, lifestealMax, true));
        REFLEX = SpecialBuffRegistry.register(new FloatBuff(ResourceUtil.fromNamespaceAndPath("bestia", "reflex"), 0.0f, reflexBuff, reflexMax, false));
        DAZE = SpecialBuffRegistry.register(new IntegerBuff(ResourceUtil.fromNamespaceAndPath("bestia", "daze"), 0, dazeBuff, dazeMax));
        HOLD = SpecialBuffRegistry.register(new BooleanBuff(ResourceUtil.fromNamespaceAndPath("bestia", "hold")));
    }

    public static void reinitializeForClient() {
        ClientConfigStore config = ClientConfigStore.INSTANCE;
        int rerollMax = config.rerollMaxLevel;
        int executeMax = config.executeMaxLevel;
        int lifestealMax = config.lifestealMaxLevel;
        int reflexMax = config.reflexMaxLevel;
        int dazeMax = config.dazeMaxLevel;
        float executeBuff = (float)config.executeBuffPerLevel;
        float lifestealBuff = (float)config.lifestealBuffPerLevel;
        float reflexBuff = (float)config.reflexBuffPerLevel;
        int dazeBuff = config.dazeBuffPerLevel;
        REROLL = SpecialBuffRegistry.register(new IntegerBuff(ResourceUtil.fromNamespaceAndPath("bestia", "reroll"), 0, 1, rerollMax));
        EXECUTE = SpecialBuffRegistry.register(new FloatBuff(ResourceUtil.fromNamespaceAndPath("bestia", "execute"), 0.0f, executeBuff, executeMax, true));
        LIFESTEAL = SpecialBuffRegistry.register(new FloatBuff(ResourceUtil.fromNamespaceAndPath("bestia", "lifesteal"), 0.0f, lifestealBuff, lifestealMax, true));
        REFLEX = SpecialBuffRegistry.register(new FloatBuff(ResourceUtil.fromNamespaceAndPath("bestia", "reflex"), 0.0f, reflexBuff, reflexMax, false));
        DAZE = SpecialBuffRegistry.register(new IntegerBuff(ResourceUtil.fromNamespaceAndPath("bestia", "daze"), 0, dazeBuff, dazeMax));
        HOLD = SpecialBuffRegistry.register(new BooleanBuff(ResourceUtil.fromNamespaceAndPath("bestia", "hold")));
    }

    public static <T> SpecialBuff<T> register(SpecialBuff<T> buff) {
        BUFFS.put(buff.getId(), buff);
        return buff;
    }

    public static SpecialBuff<?> get(ResourceLocation id) {
        return BUFFS.get(id);
    }

    public static Collection<SpecialBuff<?>> all() {
        return BUFFS.values();
    }
}

