/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.luko.bestia.client.ClientBestiaryData;
import net.luko.bestia.data.BestiaryData;
import net.luko.bestia.data.BestiaryDataSerializer;
import net.luko.bestia.screen.BestiaryScreen;
import net.luko.bestia.screen.side.BestiarySideScreenComponent;
import net.luko.bestia.screen.side.FocusedBestiaryEntryScreenComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class BestiarySyncPacket {
    private final Map<ResourceLocation, BestiaryData> data;

    public BestiarySyncPacket(Map<ResourceLocation, BestiaryData> data) {
        this.data = data;
    }

    public static void encode(BestiarySyncPacket packet, FriendlyByteBuf buf) {
        buf.m_130130_(packet.data.size());
        for (Map.Entry<ResourceLocation, BestiaryData> entry : packet.data.entrySet()) {
            buf.m_130085_(entry.getKey());
            BestiaryDataSerializer.write(buf, entry.getValue());
        }
    }

    public static BestiarySyncPacket decode(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        HashMap<ResourceLocation, BestiaryData> map = new HashMap<ResourceLocation, BestiaryData>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation mobId = buf.m_130281_();
            BestiaryData data = BestiaryDataSerializer.read(buf);
            map.put(mobId, data);
        }
        return new BestiarySyncPacket(map);
    }

    public static void handle(BestiarySyncPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            BestiaryScreen bestiaryScreen;
            BestiarySideScreenComponent patt1966$temp;
            ClientBestiaryData.set(packet.data);
            Screen patt1855$temp = Minecraft.m_91087_().f_91080_;
            if (patt1855$temp instanceof BestiaryScreen && (patt1966$temp = (bestiaryScreen = (BestiaryScreen)patt1855$temp).getActiveSideScreenComponent()) instanceof FocusedBestiaryEntryScreenComponent) {
                FocusedBestiaryEntryScreenComponent focusedBestiaryEntryScreenComponent = (FocusedBestiaryEntryScreenComponent)patt1966$temp;
                bestiaryScreen.rebuiltEntries(ClientBestiaryData.getAll());
                focusedBestiaryEntryScreenComponent.refresh(ClientBestiaryData.getFor(focusedBestiaryEntryScreenComponent.getMobId()));
            }
        });
        context.setPacketHandled(true);
    }
}

