/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.network;

import java.util.function.Supplier;
import net.luko.bestia.data.BestiaryManager;
import net.luko.bestia.data.PlayerBestiaryStore;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ClearPointsPacket {
    private final ResourceLocation mobId;

    public ClearPointsPacket(ResourceLocation mobId) {
        this.mobId = mobId;
    }

    public static void encode(ClearPointsPacket packet, FriendlyByteBuf buf) {
        buf.m_130085_(packet.mobId);
    }

    public static ClearPointsPacket decode(FriendlyByteBuf buf) {
        ResourceLocation mobId = buf.m_130281_();
        return new ClearPointsPacket(mobId);
    }

    public static void handle(ClearPointsPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                BestiaryManager manager = PlayerBestiaryStore.get(player);
                manager.onClearPointsWithSync(player, packet.mobId);
            }
        });
        context.setPacketHandled(true);
    }
}

