/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.network;

import java.util.List;
import java.util.function.Supplier;
import net.luko.bestia.data.leaderboard.LeaderboardEntry;
import net.luko.bestia.data.leaderboard.LeaderboardManager;
import net.luko.bestia.network.LeaderboardPacket;
import net.luko.bestia.network.ModPackets;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class RequestLeaderboardPacket {
    private final ResourceLocation mobId;

    public RequestLeaderboardPacket(ResourceLocation mobId) {
        this.mobId = mobId;
    }

    public static void encode(RequestLeaderboardPacket packet, FriendlyByteBuf buf) {
        buf.m_130085_(packet.mobId);
    }

    public static RequestLeaderboardPacket decode(FriendlyByteBuf buf) {
        return new RequestLeaderboardPacket(buf.m_130281_());
    }

    public static void handle(RequestLeaderboardPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            List<LeaderboardEntry> leaderboard = LeaderboardManager.getLeaderboard(packet.mobId, context.getSender().m_20194_());
            ModPackets.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new LeaderboardPacket(packet.mobId, leaderboard));
        });
        context.setPacketHandled(true);
    }
}

