/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.luko.bestia.client.ModKeybinds;
import net.luko.bestia.config.BestiaClientConfig;
import net.luko.bestia.data.BestiaryData;
import net.luko.bestia.data.leaderboard.LeaderboardEntry;
import net.luko.bestia.screen.BestiaryTooltip;
import net.luko.bestia.screen.side.BestiaryEntryScreenComponent;
import net.luko.bestia.screen.side.BestiaryInfoScreenComponent;
import net.luko.bestia.screen.side.BestiaryLeaderboardScreenComponent;
import net.luko.bestia.screen.side.BestiarySideScreenComponent;
import net.luko.bestia.screen.side.FocusedBestiaryEntryScreenComponent;
import net.luko.bestia.screen.widget.CustomButton;
import net.luko.bestia.screen.widget.ScrollBarWidget;
import net.luko.bestia.util.MobIdUtil;
import net.luko.bestia.util.ResourceUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

public class BestiaryScreen
extends Screen {
    private static final ResourceLocation PANEL_TEXTURE = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/panel.png");
    private static final int PANEL_TEXTURE_WIDTH = 336;
    private static final int PANEL_TEXTURE_HEIGHT = 384;
    private static final int PANEL_BLIT_WIDTH = 336;
    private static final int PANEL_BLIT_HEIGHT = 384;
    private static final int PADDING = 8;
    private static final int HORIZONTAL_ENTRY_BLIT_MARGIN = 58;
    private static final int HORIZONTAL_ENTRY_BLIT_PADDING = 4;
    private static final float SCALE = 1.0f;
    private static final int PANEL_TOP_UV_HEIGHT = 54;
    private static final int PANEL_BOTTOM_UV_HEIGHT = 54;
    private static final int PANEL_MIDDLE_UV_HEIGHT = 276;
    private static final int PANEL_TOP_BLIT_HEIGHT = Math.round(54.0f);
    private static final int PANEL_BOTTOM_BLIT_HEIGHT = Math.round(54.0f);
    private static final int PANEL_MIDDLE_BLIT_HEIGHT = 384 - PANEL_TOP_BLIT_HEIGHT - PANEL_BOTTOM_BLIT_HEIGHT;
    private int leftPos;
    private int topPos;
    private int leftPosMoveTo;
    private final List<BestiaryEntryScreenComponent> bestiaryEntryScreenComponents = new ArrayList<BestiaryEntryScreenComponent>();
    private List<BestiaryEntryScreenComponent> filteredEntries;
    private EditBox searchBox;
    private BestiarySideScreenComponent activeSideScreenComponent = null;
    private CustomButton infoToggleButton;
    private CustomButton zoomInButton;
    private CustomButton zoomOutButton;
    private ScrollBarWidget scrollBar;
    private static boolean shownBefore;
    public static final int MARGIN = 4;
    private float scrollAmount = 0.0f;
    private int leftPosPrev;
    private boolean onlySideScreen = false;
    private int sideScreenWidth = 0;
    private static final int MAX_ZOOM = 1;
    private static final int MIN_ZOOM = 3;
    private int zoom = 1;

    public BestiaryScreen(Map<ResourceLocation, BestiaryData> entries) {
        super((Component)Component.m_237113_((String)"Bestiary"));
        shownBefore = (Boolean)BestiaClientConfig.SHOWN_BEFORE.get();
        for (Map.Entry<ResourceLocation, BestiaryData> entry : entries.entrySet()) {
            this.bestiaryEntryScreenComponents.add(new BestiaryEntryScreenComponent(entry.getKey(), entry.getValue(), this, false));
        }
        this.filterEntries("");
    }

    protected int getInfoToggleButtonX() {
        return this.leftPos + 36;
    }

    protected int getSearchBoxX() {
        return this.leftPos + 168 - 104;
    }

    protected int getZoomInButtonX() {
        return this.leftPos + 336 - 86;
    }

    protected int getZoomOutButtonX() {
        return this.leftPos + 336 - 60;
    }

    private int getScrollBarX() {
        return this.leftPos + 336 - 58 + 2;
    }

    private int getScrollBarThumbHeight() {
        return (int)((float)this.getVisibleHeight() / this.getContentHeight() * (float)this.getScrollBarTrackHeight());
    }

    private int getScrollBarTrackHeight() {
        return this.getPanelContentHeight() - PANEL_TOP_BLIT_HEIGHT - PANEL_BOTTOM_BLIT_HEIGHT + 12;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPosPrev = this.leftPos = (this.f_96543_ - 336) / 2;
        this.topPos = 16;
        this.searchBox = new EditBox(this.f_96547_, this.getSearchBoxX(), this.topPos + 13, 180, 21, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94151_(this::filterEntries);
        this.searchBox.m_94182_(true);
        this.searchBox.m_94194_(true);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.infoToggleButton = new CustomButton(this.getInfoToggleButtonX(), this.topPos + 13, 21, 21, (Component)Component.m_237113_((String)"i"), btn -> {
            if (this.activeSideScreenComponent instanceof BestiaryInfoScreenComponent) {
                this.clearSideScreenComponent();
            } else {
                this.openInfoScreenComponent();
            }
            shownBefore = true;
            BestiaClientConfig.SHOWN_BEFORE.set((Object)true);
        });
        this.zoomInButton = new CustomButton(this.getZoomInButtonX(), this.topPos + 13, 21, 21, (Component)Component.m_237113_((String)"+"), btn -> this.tryZoomIn());
        this.zoomOutButton = new CustomButton(this.getZoomOutButtonX(), this.topPos + 13, 21, 21, (Component)Component.m_237113_((String)"-"), btn -> this.tryZoomOut());
        this.scrollBar = new ScrollBarWidget(this.getScrollBarX(), this.topPos + PANEL_TOP_BLIT_HEIGHT - 6, 4, this.getScrollBarTrackHeight(), (Component)Component.m_237113_((String)"Scroll"), this.getScrollBarThumbHeight(), normalized -> {
            this.scrollAmount = normalized.floatValue() * this.getMaxScroll();
        });
        this.scrollBar.f_93624_ = this.getMaxScroll() != 0.0f;
        this.m_142416_((GuiEventListener)this.infoToggleButton);
        this.m_142416_((GuiEventListener)this.zoomInButton);
        this.m_142416_((GuiEventListener)this.zoomOutButton);
        this.m_142416_((GuiEventListener)this.scrollBar);
        if (!shownBefore) {
            this.openInfoScreenComponent();
        } else {
            this.clearSideScreenComponent();
        }
    }

    public void rebuiltEntries(Map<ResourceLocation, BestiaryData> entries) {
        this.bestiaryEntryScreenComponents.clear();
        for (Map.Entry<ResourceLocation, BestiaryData> entry : entries.entrySet()) {
            this.bestiaryEntryScreenComponents.add(new BestiaryEntryScreenComponent(entry.getKey(), entry.getValue(), this, false));
        }
        this.updateSearch();
    }

    public void openInfoScreenComponent() {
        this.clearSideScreenComponent();
        int maxWidth = 200;
        this.sideScreenWidth = this.getSideScreenComponentWidth(maxWidth, true);
        int minWidthToRemoveMainPanel = 40;
        if (this.sideScreenWidth < minWidthToRemoveMainPanel) {
            this.sideScreenWidth = this.getSideScreenComponentWidth(maxWidth, false);
            this.onlySideScreen = true;
        }
        int mainPanelWidthAdjustment = this.onlySideScreen ? 0 : 336;
        this.activeSideScreenComponent = new BestiaryInfoScreenComponent(this.leftPos + mainPanelWidthAdjustment + 4, this.topPos + PANEL_TOP_BLIT_HEIGHT - 6, this.sideScreenWidth, this);
        this.updateLeftPosMoveTo();
    }

    public void openFocusedEntryScreenComponent(ResourceLocation mobId, BestiaryData data) {
        this.clearSideScreenComponent();
        int max = 424;
        this.sideScreenWidth = this.getSideScreenComponentWidth(max, true);
        int minWidthToRemoveMainPanel = 212;
        if (this.sideScreenWidth < minWidthToRemoveMainPanel) {
            this.sideScreenWidth = this.getSideScreenComponentWidth(max, false);
            this.onlySideScreen = true;
        }
        int mainPanelWidthAdjustment = this.onlySideScreen ? 0 : 336;
        this.activeSideScreenComponent = new FocusedBestiaryEntryScreenComponent(this.leftPos + mainPanelWidthAdjustment + 4, this.topPos + PANEL_TOP_BLIT_HEIGHT - 6, this.sideScreenWidth, this, mobId, data);
        this.updateLeftPosMoveTo();
    }

    public void openLeaderboardScreenComponent(ResourceLocation mobId, List<LeaderboardEntry> leaderboard) {
        this.clearSideScreenComponent();
        int max = 360;
        this.sideScreenWidth = this.getSideScreenComponentWidth(max, true);
        int minWidthToRemoveMainPanel = BestiaryLeaderboardScreenComponent.getNeededWidth();
        if (this.sideScreenWidth < minWidthToRemoveMainPanel) {
            this.sideScreenWidth = this.getSideScreenComponentWidth(max, false);
            this.onlySideScreen = true;
        }
        int mainPanelWidthAdjustment = this.onlySideScreen ? 0 : 336;
        this.activeSideScreenComponent = new BestiaryLeaderboardScreenComponent(this.leftPos + mainPanelWidthAdjustment + 4, this.topPos + PANEL_TOP_BLIT_HEIGHT - 6, this.sideScreenWidth, this, mobId, leaderboard);
        this.updateLeftPosMoveTo();
    }

    public void clearSideScreenComponent() {
        this.activeSideScreenComponent = null;
        this.onlySideScreen = false;
        this.sideScreenWidth = 0;
        this.updateLeftPosMoveTo();
        shownBefore = true;
        BestiaClientConfig.SHOWN_BEFORE.set((Object)true);
    }

    public BestiarySideScreenComponent getActiveSideScreenComponent() {
        return this.activeSideScreenComponent;
    }

    private int getSideScreenComponentWidth(int max, boolean withMain) {
        int availableWidth = withMain ? this.f_96543_ - 336 - 12 : this.f_96543_ - 12;
        return Math.min(max, availableWidth);
    }

    public void updateLeftPosMoveTo() {
        this.leftPosMoveTo = this.onlySideScreen ? (this.f_96543_ - this.sideScreenWidth - 12) / 2 : Math.max(this.activeSideScreenComponent != null ? (this.f_96543_ - 336 - this.sideScreenWidth) / 2 - 2 : (this.f_96543_ - 336) / 2, 4);
    }

    public void updateLeftPos() {
        this.leftPosPrev = this.leftPos;
        this.leftPos += (int)((double)(this.leftPosMoveTo - this.leftPos) * 0.4);
    }

    public void updatePositions() {
        int mainPanelWidthAdjustment;
        int n = mainPanelWidthAdjustment = this.onlySideScreen ? 0 : 336;
        if (this.activeSideScreenComponent != null) {
            this.activeSideScreenComponent.moveX(this.leftPos + mainPanelWidthAdjustment + 4);
        }
        if (this.onlySideScreen) {
            this.searchBox.f_93624_ = false;
            this.infoToggleButton.f_93624_ = false;
            this.zoomInButton.f_93624_ = false;
            this.zoomOutButton.f_93624_ = false;
            this.scrollBar.f_93624_ = false;
        } else {
            this.searchBox.f_93624_ = true;
            this.infoToggleButton.f_93624_ = true;
            this.zoomInButton.f_93624_ = true;
            this.zoomOutButton.f_93624_ = true;
            if (this.getMaxScroll() > 0.0f) {
                this.scrollBar.f_93624_ = true;
            }
            this.searchBox.m_252865_(this.getSearchBoxX());
            this.infoToggleButton.m_252865_(this.getInfoToggleButtonX());
            this.zoomInButton.m_252865_(this.getZoomInButtonX());
            this.zoomOutButton.m_252865_(this.getZoomOutButtonX());
            this.scrollBar.m_252865_(this.getScrollBarX());
        }
    }

    private void updateSearch() {
        this.filterEntries(this.searchBox.m_94155_());
    }

    private void filterEntries(String newText) {
        String query = newText.trim().toLowerCase();
        this.filteredEntries = this.bestiaryEntryScreenComponents.stream().filter(entry -> entry.getDisplayName().toLowerCase().contains(query)).filter(entry -> MobIdUtil.validBestiaryMob(entry.getMobId(), LogicalSide.CLIENT)).sorted(Comparator.comparingInt(BestiaryEntryScreenComponent::kills).reversed()).toList();
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        List<Component> tooltipToRender;
        if (this.leftPos != this.leftPosMoveTo) {
            this.updateLeftPos();
        }
        this.m_280273_(guiGraphics);
        int uninterpolatedLeftPos = this.leftPos;
        this.leftPos = (int)((float)this.leftPosPrev + (float)(this.leftPos - this.leftPosPrev) * partialTick);
        if (this.activeSideScreenComponent != null) {
            this.activeSideScreenComponent.render(guiGraphics, mouseX, mouseY);
        }
        this.updatePositions();
        if (!this.onlySideScreen) {
            this.drawPanel(guiGraphics);
            this.renderEntries(guiGraphics, mouseX, mouseY);
        }
        if ((tooltipToRender = this.getTooltip(mouseX, mouseY)) != null) {
            guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, tooltipToRender, Optional.empty(), mouseX, mouseY);
        }
        this.leftPos = uninterpolatedLeftPos;
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void drawPanel(GuiGraphics guiGraphics) {
        guiGraphics.m_280411_(PANEL_TEXTURE, this.leftPos, this.topPos, 336, PANEL_TOP_BLIT_HEIGHT, 0.0f, 0.0f, 336, 54, 336, 384);
        int middleTopPos = this.topPos + PANEL_TOP_BLIT_HEIGHT;
        int availableMiddleHeight = this.getPanelContentHeight() - PANEL_TOP_BLIT_HEIGHT - PANEL_BOTTOM_BLIT_HEIGHT;
        if (availableMiddleHeight <= 0) {
            return;
        }
        for (int i = 0; i < availableMiddleHeight; i += PANEL_MIDDLE_BLIT_HEIGHT) {
            int drawHeight = Math.min(PANEL_MIDDLE_BLIT_HEIGHT, availableMiddleHeight - i);
            guiGraphics.m_280411_(PANEL_TEXTURE, this.leftPos, middleTopPos + i, 336, drawHeight, 0.0f, 54.0f, 336, 276, 336, 384);
        }
        guiGraphics.m_280411_(PANEL_TEXTURE, this.leftPos, middleTopPos + availableMiddleHeight, 336, PANEL_BOTTOM_BLIT_HEIGHT, 0.0f, 330.0f, 336, 54, 336, 384);
    }

    private void renderEntries(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(1.0f / (float)this.zoom, 1.0f / (float)this.zoom, 1.0f);
        int scissorX = this.leftPos;
        int scissorY = this.topPos + PANEL_TOP_BLIT_HEIGHT - 6;
        int scissorWidth = 336;
        int scissorHeight = this.getPanelContentHeight() - PANEL_TOP_BLIT_HEIGHT - PANEL_BOTTOM_BLIT_HEIGHT + 12;
        int scaleFactor = (int)Minecraft.m_91087_().m_91268_().m_85449_();
        int windowHeight = Minecraft.m_91087_().m_91268_().m_85442_();
        RenderSystem.enableScissor((int)(scissorX * scaleFactor), (int)(windowHeight - (scissorY + scissorHeight) * scaleFactor), (int)(scissorWidth * scaleFactor), (int)(scissorHeight * scaleFactor));
        int minX = this.leftPos + 58 + 4 / this.zoom;
        minX *= this.zoom;
        int[] xCoords = new int[this.zoom];
        int columnOffset = 218;
        for (int i = 0; i < xCoords.length; ++i) {
            xCoords[i] = minX + i * columnOffset;
        }
        int column = 0;
        int yOffset = this.topPos + PANEL_TOP_BLIT_HEIGHT + 8 - (int)this.scrollAmount;
        int y = yOffset *= this.zoom;
        for (BestiaryEntryScreenComponent entry : this.filteredEntries) {
            if (y > -69 && y < this.f_96544_ * this.zoom) {
                entry.render(guiGraphics, xCoords[column], y);
                if (this.mouseInScissor(mouseX, mouseY)) {
                    entry.checkMouse(xCoords[column], y, mouseX * this.zoom, mouseY * this.zoom);
                }
            }
            if (++column != this.zoom) continue;
            column = 0;
            y += 77;
        }
        RenderSystem.disableScissor();
        poseStack.m_85849_();
    }

    private boolean mouseInScissor(int mouseX, int mouseY) {
        return mouseX >= this.leftPos + 58 && mouseX <= this.leftPos + 336 - 58 && mouseY >= this.topPos + PANEL_TOP_BLIT_HEIGHT && mouseY <= this.topPos - PANEL_TOP_BLIT_HEIGHT + this.getPanelContentHeight();
    }

    @Nullable
    private List<Component> getTooltip(int mouseX, int mouseY) {
        List<Component> tooltipToRender = null;
        if (!this.onlySideScreen && this.mouseInScissor(mouseX, mouseY)) {
            block0: for (BestiaryEntryScreenComponent component : this.bestiaryEntryScreenComponents) {
                for (BestiaryTooltip tooltip : component.getTooltips()) {
                    if (!tooltip.contains(mouseX * this.zoom, mouseY * this.zoom)) continue;
                    tooltipToRender = tooltip.tooltip();
                    continue block0;
                }
            }
        }
        if (this.activeSideScreenComponent != null) {
            for (BestiaryTooltip tooltip : this.activeSideScreenComponent.getTooltips()) {
                if (!tooltip.contains(mouseX, mouseY)) continue;
                tooltipToRender = tooltip.tooltip();
                break;
            }
        }
        return tooltipToRender;
    }

    private int getPanelContentHeight() {
        return this.f_96544_ - this.topPos * 2;
    }

    public void tryZoomOut() {
        this.zoom = Mth.m_14045_((int)(++this.zoom), (int)1, (int)3);
        this.scrollAmount = 0.0f;
        this.updateScrollBar();
    }

    public void tryZoomIn() {
        this.zoom = Mth.m_14045_((int)(--this.zoom), (int)1, (int)3);
        this.scrollAmount = 0.0f;
        this.updateScrollBar();
    }

    public float getContentHeight() {
        int rows = (int)Math.ceil((float)this.filteredEntries.size() / (float)this.zoom);
        return (float)rows * 77.0f / (float)this.zoom;
    }

    public int getVisibleHeight() {
        return this.f_96544_ - 8 - 2 * this.topPos - PANEL_TOP_BLIT_HEIGHT - PANEL_BOTTOM_BLIT_HEIGHT;
    }

    public float getMaxScroll() {
        return Math.max(0.0f, this.getContentHeight() - (float)this.getVisibleHeight());
    }

    public void updateScrollBar() {
        float maxScroll = this.getMaxScroll();
        if (maxScroll <= 0.0f) {
            this.scrollBar.f_93624_ = false;
            return;
        }
        this.scrollBar.setThumbHeight(this.getScrollBarThumbHeight());
        this.scrollBar.setScrollAmount(this.scrollAmount / this.getMaxScroll());
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.onlySideScreen && this.mouseInScissor((int)mouseX, (int)mouseY)) {
            this.scrollAmount -= (float)delta * 30.0f;
            float maxScroll = this.getMaxScroll();
            this.scrollAmount = Mth.m_14036_((float)this.scrollAmount, (float)0.0f, (float)maxScroll);
            this.updateScrollBar();
            return true;
        }
        if (this.activeSideScreenComponent != null && this.activeSideScreenComponent.mouseScrolled(mouseX, mouseY, delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.onlySideScreen) {
            for (BestiaryEntryScreenComponent entry : this.filteredEntries) {
                if (!entry.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        if (this.activeSideScreenComponent != null && this.activeSideScreenComponent.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrollBar.m_6348_(mouseX, mouseY, button);
        if (this.activeSideScreenComponent != null) {
            this.activeSideScreenComponent.mouseReleased(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.activeSideScreenComponent != null && this.activeSideScreenComponent.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (((KeyMapping)ModKeybinds.KEY_OPEN_BESTIARY.get()).m_90832_(keyCode, scanCode)) {
            Minecraft.m_91087_().m_91152_(null);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

