/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.luko.bestia.data.BestiaryManager;
import net.luko.bestia.data.PlayerBestiaryStore;
import net.luko.bestia.data.buff.special.SpecialBuffRegistry;
import net.luko.bestia.util.ResourceUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="bestia", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ApplySpecialBuffs {
    private static final ResourceLocation EXECUTE_SOURCE = ResourceUtil.fromNamespaceAndPath("bestia", "execute");
    private static final ResourceKey<Registry<DamageType>> DAMAGE_TYPE_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceUtil.fromNamespaceAndPath("minecraft", "damage_type"));
    private static Map<UUID, Integer> mobAITickCounts = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void applyRerollBuff(LivingDropsEvent event) {
        Projectile proj;
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        Level level = entity2.m_9236_();
        if (level.f_46443_) {
            return;
        }
        ServerPlayer player = null;
        Entity source = event.getSource().m_7639_();
        if (source instanceof ServerPlayer) {
            ServerPlayer sp1;
            player = sp1 = (ServerPlayer)source;
        }
        if (source instanceof Projectile && (entity = (proj = (Projectile)source).m_19749_()) instanceof ServerPlayer) {
            ServerPlayer sp2;
            player = sp2 = (ServerPlayer)entity;
        }
        if (player == null) {
            return;
        }
        ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity2.m_6095_());
        BestiaryManager manager = PlayerBestiaryStore.get(player);
        if (manager == null) {
            return;
        }
        int rerolls = manager.getSpecialBuffValue(SpecialBuffRegistry.REROLL, mobId);
        if (rerolls <= 0) {
            return;
        }
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return;
        }
        LootTable lootTable = server.m_278653_().m_278676_(entity2.m_5743_());
        if (lootTable == LootTable.f_79105_) {
            return;
        }
        ArrayList extraLoot = new ArrayList();
        LootParams lootParams = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81455_, (Object)entity2).m_287286_(LootContextParams.f_81460_, (Object)entity2.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)event.getSource()).m_287289_(LootContextParams.f_81456_, (Object)player).m_287289_(LootContextParams.f_81458_, (Object)player).m_287235_(LootContextParamSets.f_81415_);
        for (int i = 0; i < rerolls; ++i) {
            extraLoot.addAll(lootTable.m_287195_(lootParams));
        }
        for (ItemStack stack : extraLoot) {
            ItemEntity itemEntity = new ItemEntity(level, entity2.m_20185_(), entity2.m_20188_(), entity2.m_20189_(), stack);
            event.getDrops().add(itemEntity);
        }
    }

    @SubscribeEvent
    public static void applyExecuteBuff(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        LivingEntity entity2 = event.getEntity();
        ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity2.m_6095_());
        BestiaryManager manager = PlayerBestiaryStore.get(player);
        if (manager == null) {
            return;
        }
        float threshold = manager.getSpecialBuffValue(SpecialBuffRegistry.EXECUTE, mobId).floatValue();
        if (threshold <= 0.0f) {
            return;
        }
        if (entity2.m_21223_() >= entity2.m_21233_() * threshold) {
            return;
        }
        Holder.Reference holder = player.f_8924_.m_206579_().m_175515_(DAMAGE_TYPE_REGISTRY_KEY).m_246971_(DamageTypes.f_268724_);
        DamageSource source = new DamageSource((Holder)holder, (Entity)player, (Entity)player);
        entity2.m_21153_(0.0f);
        entity2.m_6667_(source);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void applyLifestealBuff(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_());
        BestiaryManager manager = PlayerBestiaryStore.get(player);
        if (manager == null) {
            return;
        }
        float lifesteal = manager.getSpecialBuffValue(SpecialBuffRegistry.LIFESTEAL, mobId).floatValue();
        if (lifesteal <= 0.0f) {
            return;
        }
        player.m_5634_(event.getAmount() * lifesteal);
    }

    @SubscribeEvent
    public static void applyReflexBuff(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)attacker.m_6095_());
        BestiaryManager manager = PlayerBestiaryStore.get(player);
        if (manager == null) {
            return;
        }
        float force = manager.getSpecialBuffValue(SpecialBuffRegistry.REFLEX, mobId).floatValue();
        if (force > 0.0f) {
            attacker.m_147240_((double)force, player.m_20185_() - attacker.m_20185_(), player.m_20189_() - attacker.m_20189_());
        }
    }

    @SubscribeEvent
    public static void applyDazeBuff(LivingAttackEvent event) {
        MinecraftServer server;
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        LivingEntity target = event.getEntity();
        if (target.m_9236_().f_46443_) {
            return;
        }
        if (!(target instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)target;
        ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_());
        BestiaryManager manager = PlayerBestiaryStore.get(player);
        if (manager == null) {
            return;
        }
        int ticks = manager.getSpecialBuffValue(SpecialBuffRegistry.DAZE, mobId);
        if (ticks > 0 && (server = mob.m_20194_()) != null) {
            mob.f_21345_.m_25355_(Goal.Flag.MOVE);
            mob.f_21345_.m_25355_(Goal.Flag.LOOK);
            mob.f_21345_.m_25355_(Goal.Flag.JUMP);
            mob.f_21346_.m_25355_(Goal.Flag.TARGET);
            mob.m_21573_().m_26573_();
            mob.m_6710_(null);
            mob.m_6703_(null);
            mob.m_6274_().m_21936_(MemoryModuleType.f_26372_);
            mobAITickCounts.put(mob.m_20148_(), ticks);
        }
    }

    @SubscribeEvent
    public static void resetDazeApplications(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        HashMap<UUID, Integer> newTickCounts = new HashMap<UUID, Integer>();
        for (Map.Entry<UUID, Integer> entry : mobAITickCounts.entrySet()) {
            Mob mob = null;
            for (ServerLevel level : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
                Mob m;
                Entity e = level.m_8791_(entry.getKey());
                if (!(e instanceof Mob)) continue;
                mob = m = (Mob)e;
                break;
            }
            if (mob == null || !mob.m_6084_()) continue;
            if (entry.getValue() <= 0) {
                mob.f_21345_.m_25374_(Goal.Flag.MOVE);
                mob.f_21345_.m_25374_(Goal.Flag.LOOK);
                mob.f_21345_.m_25374_(Goal.Flag.JUMP);
                mob.f_21346_.m_25374_(Goal.Flag.TARGET);
                continue;
            }
            mob.m_6710_(null);
            mob.m_21573_().m_26573_();
            newTickCounts.put(entry.getKey(), entry.getValue() - 1);
        }
        mobAITickCounts = newTickCounts;
    }

    @SubscribeEvent
    public static void markToCancelKnockback(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        LivingEntity target = event.getEntity();
        if (target.m_9236_().f_46443_) {
            return;
        }
        ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_());
        BestiaryManager manager = PlayerBestiaryStore.get(player);
        if (manager == null) {
            return;
        }
        if (!manager.getSpecialBuffValue(SpecialBuffRegistry.HOLD, mobId).booleanValue()) {
            return;
        }
        target.getPersistentData().m_128379_("BestiaryHoldBuffActive", true);
    }

    @SubscribeEvent
    public static void applyHoldBuff(LivingKnockBackEvent event) {
        LivingEntity target = event.getEntity();
        if (target.m_9236_().f_46443_) {
            return;
        }
        if (!target.getPersistentData().m_128471_("BestiaryHoldBuffActive")) {
            return;
        }
        event.setStrength(0.0f);
        target.getPersistentData().m_128473_("BestiaryHoldBuffActive");
    }
}

