/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.server;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.luko.bestia.Bestia;
import net.luko.bestia.config.BestiaCommonConfig;
import net.luko.bestia.data.BestiaryKey;
import net.luko.bestia.data.BestiaryManager;
import net.luko.bestia.data.PlayerBestiaryStore;
import net.luko.bestia.data.buff.MobBuff;
import net.luko.bestia.network.ConfigSyncPacket;
import net.luko.bestia.network.ModPackets;
import net.luko.bestia.server.BestiaryOfflineCache;
import net.luko.bestia.util.MobIdUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="bestia", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerModEvents {
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onServerStart(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        BestiaryOfflineCache.clear();
        File playerDataFolder = server.m_129843_(LevelResource.f_78176_).toFile();
        if (!playerDataFolder.exists() || !playerDataFolder.isDirectory()) {
            Bestia.LOGGER.warn("Player data folder not found: {}", (Object)playerDataFolder.getAbsolutePath());
            return;
        }
        File[] files = playerDataFolder.listFiles((dir, name) -> name.endsWith(".dat"));
        if (files == null) {
            Bestia.LOGGER.warn("Files is null? Strange error");
            return;
        }
        Bestia.LOGGER.debug("Attempting to cache bestiary data from {} playerdata files", (Object)files.length);
        for (File file : files) {
            try {
                String name2 = file.getName().replace(".dat", "");
                if (!UUID_PATTERN.matcher(name2).matches()) {
                    Bestia.LOGGER.warn("Skipping file {}, invalid UUID formal (likely a backup)", (Object)file.getName());
                    continue;
                }
                UUID uuid = UUID.fromString(name2);
                CompoundTag playerTag = NbtIo.m_128937_((File)file);
                CompoundTag forgeData = playerTag.m_128469_("ForgeData");
                if (!forgeData.m_128441_(BestiaryKey.ROOT.get())) continue;
                CompoundTag bestiaryTag = forgeData.m_128469_(BestiaryKey.ROOT.get());
                BestiaryOfflineCache.put(uuid, bestiaryTag);
            }
            catch (IOException | RuntimeException e) {
                Bestia.LOGGER.error("Failed to load bestiary data from {} ", (Object)file.getName(), (Object)e);
            }
        }
        Bestia.LOGGER.info("Loaded {} offline player bestiary entries", (Object)BestiaryOfflineCache.size());
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ModPackets.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new ConfigSyncPacket(BestiaCommonConfig.createConfigToSync()));
        UUID uuid = player2.m_20148_();
        CompoundTag bestiaryTag = BestiaryOfflineCache.get(uuid);
        if (bestiaryTag != null) {
            Bestia.LOGGER.debug("Found offline cache for player {}", (Object)uuid);
            BestiaryOfflineCache.remove(uuid);
        } else {
            Bestia.LOGGER.debug("Could not find offline cache for player {}, falling back", (Object)uuid);
            bestiaryTag = player2.getPersistentData().m_128469_(BestiaryKey.ROOT.get());
        }
        BestiaryManager manager = new BestiaryManager();
        manager.loadFromNBT(bestiaryTag, event.getEntity().m_7755_().getString());
        manager.syncToPlayer(player2);
        PlayerBestiaryStore.set(player2, manager);
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        BestiaryManager manager = PlayerBestiaryStore.get(player2);
        if (manager == null) {
            Bestia.LOGGER.warn("Bestiary manager for player {} was null", (Object)player2);
            return;
        }
        CompoundTag tag = manager.serializeNBT();
        player2.getPersistentData().m_128365_(BestiaryKey.ROOT.get(), (Tag)tag);
        BestiaryOfflineCache.put(player2.m_20148_(), tag);
        PlayerBestiaryStore.remove(player2);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tickCounter >= (Integer)BestiaCommonConfig.AUTOSAVE_INTERVAL.get()) {
            tickCounter = 0;
            ServerModEvents.autosaveAllPlayers();
        }
    }

    private static void autosaveAllPlayers() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        List playerList = server.m_6846_().m_11314_();
        for (ServerPlayer player : playerList) {
            BestiaryManager manager = PlayerBestiaryStore.get(player);
            if (manager == null) continue;
            CompoundTag tag = manager.serializeNBT();
            player.getPersistentData().m_128365_(BestiaryKey.ROOT.get(), (Tag)tag);
        }
        Bestia.LOGGER.info("Autosaved Bestiary data for {} player{}", (Object)playerList.size(), (Object)(playerList.size() == 1 ? "" : "s"));
    }

    @SubscribeEvent
    public static void onMobKilled(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (event.getEntity() instanceof Player) {
            return;
        }
        ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_());
        if (!MobIdUtil.validBestiaryMob(mobId, LogicalSide.SERVER)) {
            return;
        }
        BestiaryManager manager = PlayerBestiaryStore.get(player);
        if (manager == null) {
            return;
        }
        manager.onKillWithSync(player, mobId);
        player.getPersistentData().m_128365_(BestiaryKey.ROOT.get(), (Tag)manager.serializeNBT());
    }

    @SubscribeEvent
    public static void onPlayerAttacksMob(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        LivingEntity target = event.getEntity();
        ResourceLocation mobId = BuiltInRegistries.f_256780_.m_7981_((Object)target.m_6095_());
        BestiaryManager manager = PlayerBestiaryStore.get(player);
        MobBuff buff = manager.getData(mobId).mobBuff();
        float modifier = buff.damageFactor();
        event.setAmount(event.getAmount() * modifier);
    }

    @SubscribeEvent
    public static void onPlayerDamaged(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        ResourceLocation mobId = BuiltInRegistries.f_256780_.m_7981_((Object)attacker.m_6095_());
        BestiaryManager manager = PlayerBestiaryStore.get(player);
        MobBuff buff = manager.getData(mobId).mobBuff();
        float modifier = buff.resistanceFactor();
        event.setAmount(event.getAmount() * modifier);
    }
}

