/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.util;

import java.util.ArrayList;
import java.util.List;
import net.luko.bestia.Bestia;
import net.luko.bestia.client.ClientConfigStore;
import net.luko.bestia.config.BestiaCommonConfig;
import net.luko.bestia.util.FormulaParser;

public class LevelFormula {
    private static String formula;

    public static void init() {
        formula = (String)BestiaCommonConfig.KILLS_FORMULA.get();
        LevelFormula.checkIfValid((Boolean)BestiaCommonConfig.MONOTONY_CHECK.get());
    }

    public static void reinitializeForClient() {
        formula = ClientConfigStore.INSTANCE.killsFormula;
    }

    private static void checkIfValid(boolean fullCheck) {
        if (!fullCheck) {
            int i;
            List samples = new ArrayList<Integer>();
            for (i = 0; i < 20; ++i) {
                samples.add((int)(Math.random() * (double)((Integer)BestiaCommonConfig.MAX_LEVEL.get()).intValue()));
            }
            samples = samples.stream().sorted().toList();
            for (i = 1; i < samples.size(); ++i) {
                if (LevelFormula.getKills((Integer)samples.get(i - 1)) <= LevelFormula.getKills((Integer)samples.get(i))) continue;
                String e = "Level to Kills mapping function is not strictly increasing: " + LevelFormula.getKills((Integer)samples.get(i - 1)) + " > " + LevelFormula.getKills((Integer)samples.get(i)) + "for levels " + String.valueOf(samples.get(i - 1)) + ", " + String.valueOf(samples.get(i));
                Bestia.LOGGER.error(e);
                throw new IllegalArgumentException(e);
            }
            return;
        }
        for (int i = 1; i < (Integer)BestiaCommonConfig.MAX_LEVEL.get(); ++i) {
            if (LevelFormula.getKills(i - 1) <= LevelFormula.getKills(i)) continue;
            String e = "Level to Kills mapping function is not strictly increasing: " + LevelFormula.getKills(i - 1) + " > " + LevelFormula.getKills(i) + "for levels " + (i - 1) + ", " + i;
            Bestia.LOGGER.error(e);
            throw new IllegalArgumentException(e);
        }
    }

    public static int getKills(int level) {
        return (int)Math.floor(FormulaParser.evaluate(formula, level));
    }

    public static int getLevel(int kills) {
        int min = 0;
        int max = (Integer)BestiaCommonConfig.MAX_LEVEL.get();
        if (kills < LevelFormula.getKills(min)) {
            return min;
        }
        if (kills > LevelFormula.getKills(max)) {
            return max;
        }
        while (min <= max) {
            int mid = (min + max) / 2;
            int req = LevelFormula.getKills(mid);
            if (req == kills) {
                return mid;
            }
            if (req < kills) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return max;
    }
}

