/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.IBlockSpecialDisplay;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.blockentity.DisplayerBlockEntity;
import org.dawnoftime.dawnoftime.registry.DoTBBlockEntitiesRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DisplayerBlock
extends WaterloggedBlock
implements EntityBlock,
IBlockSpecialDisplay {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    protected DisplayerBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return DoTBBlockEntitiesRegistry.INSTANCE.DISPLAYER.get().m_155264_(pPos, pState);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (hit.m_82434_() != Direction.UP) {
            return InteractionResult.PASS;
        }
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        Vec3 hitVec = hit.m_82450_();
        double localX = hitVec.f_82479_ - (double)pos.m_123341_();
        double localZ = hitVec.f_82481_ - (double)pos.m_123343_();
        int gridX = (int)(localX * 3.0);
        int gridZ = (int)(localZ * 3.0);
        gridX = Mth.m_14045_((int)gridX, (int)0, (int)2);
        gridZ = Mth.m_14045_((int)gridZ, (int)0, (int)2);
        int slot = gridZ * 3 + gridX;
        BlockEntity be = world.m_7702_(pos);
        if (!(be instanceof DisplayerBlockEntity)) {
            return InteractionResult.PASS;
        }
        DisplayerBlockEntity displayer = (DisplayerBlockEntity)be;
        ItemStack held = player.m_21120_(hand);
        ItemStack slotItem = displayer.m_8020_(slot);
        if (!held.m_41619_()) {
            if (slotItem.m_41619_()) {
                displayer.m_6836_(slot, held);
            } else if (held.m_41720_() == slotItem.m_41720_()) {
                if (held.m_41613_() < held.m_41741_()) {
                    held.m_41764_(held.m_41613_() + 1);
                    displayer.m_6836_(slot, ItemStack.f_41583_);
                }
            } else if (held.m_41613_() == 1) {
                player.m_21008_(hand, slotItem);
                displayer.m_6836_(slot, held);
            }
        } else if (!slotItem.m_41619_()) {
            player.m_21008_(hand, slotItem);
            displayer.m_6836_(slot, ItemStack.f_41583_);
        }
        boolean lit = displayer.isLit();
        if (lit != (Boolean)blockState.m_61143_((Property)LIT)) {
            world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit)), 10);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState oldState, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (oldState.m_60734_() != newState.m_60734_() && (tileEntity = worldIn.m_7702_(pos)) instanceof DisplayerBlockEntity) {
            DisplayerBlockEntity displayerEntity = (DisplayerBlockEntity)tileEntity;
            displayerEntity.removeAllItems().forEach(itemStack -> Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack));
        }
        super.m_6810_(oldState, worldIn, pos, newState, isMoving);
    }

    public abstract double getDisplayerX(BlockState var1);

    public abstract double getDisplayerY(BlockState var1);

    public abstract double getDisplayerZ(BlockState var1);

    @Override
    public float getDisplayScale() {
        return 0.2f;
    }
}

