/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.french;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class LimestoneGargoyleBlock
extends WaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    private static final IntegerProperty HUMIDITY = BlockStatePropertiesAA.HUMIDITY_0_8;

    public LimestoneGargoyleBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.LIMESTONE_GARGOYLE_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)HUMIDITY, (Comparable)Integer.valueOf(0))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    private int getMaxHumidity() {
        return 8;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, HUMIDITY, PERSISTENT});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return ((Direction)state.getValue((Property)FACING)).get2DDataValue();
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            if (player.isCreative()) {
                int humidity = (Integer)state.getValue((Property)HUMIDITY);
                if (player.isCrouching()) {
                    if (humidity > 0) {
                        worldIn.setBlock(pos, (BlockState)state.setValue((Property)HUMIDITY, (Comparable)Integer.valueOf(humidity - 1)), 10);
                        return InteractionResult.SUCCESS;
                    }
                } else if (humidity < this.getMaxHumidity()) {
                    worldIn.setBlock(pos, (BlockState)state.setValue((Property)HUMIDITY, (Comparable)Integer.valueOf(humidity + 1)), 10);
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (Utils.useLighter(worldIn, pos, player, handIn)) {
            Random rand = new Random();
            for (int i = 0; i < 5; ++i) {
                worldIn.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + rand.nextDouble(), (double)pos.getY() + 0.5 + rand.nextDouble() / 2.0, (double)pos.getZ() + rand.nextDouble(), 0.0, 0.07, 0.0);
            }
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 10);
            return InteractionResult.SUCCESS;
        }
        return super.use(state, worldIn, pos, player, handIn, hit);
    }

    @NotNull
    public BlockState mirror(BlockState state, @NotNull Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        int humidity = (Integer)state.getValue((Property)HUMIDITY);
        if (humidity > 0) {
            if (humidity == this.getMaxHumidity()) {
                Direction facing = (Direction)state.getValue((Property)FACING);
                double x = (double)pos.getX() + (8.0 + (double)facing.getStepX() * 6.0) / 16.0;
                double y = (double)pos.getY() + 0.59375;
                double z = (double)pos.getZ() + (8.0 + (double)facing.getStepZ() * 6.0) / 16.0;
                world.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, x, y, z, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, x, y - 0.0625, z, 0.0, 0.0, 0.0);
            } else if (rand.nextInt(this.getMaxHumidity() - humidity + 1) == 0) {
                Direction facing = (Direction)state.getValue((Property)FACING);
                double x = (double)pos.getX() + (8.0 + (double)facing.getStepX() * 6.0) / 16.0;
                double y = (double)pos.getY() + 0.59375;
                double z = (double)pos.getZ() + (8.0 + (double)facing.getStepZ() * 6.0) / 16.0;
                world.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        int humidity = (Integer)state.getValue((Property)HUMIDITY);
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            super.randomTick(state, world, pos, rand);
            return;
        }
        if (world.isRaining() && world.canSeeSky(pos)) {
            if ((Integer)state.getValue((Property)HUMIDITY) < this.getMaxHumidity()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)HUMIDITY, (Comparable)Integer.valueOf(this.getMaxHumidity())), 2);
            }
        } else if (rand.nextInt(5) == 0 && humidity > 0) {
            world.setBlock(pos, (BlockState)state.setValue((Property)HUMIDITY, (Comparable)Integer.valueOf(humidity - 1)), 2);
        }
        super.randomTick(state, world, pos, rand);
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluid) {
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && fluid.getType() == Fluids.WATER) {
            world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)HUMIDITY, (Comparable)Integer.valueOf(0)), 2);
            world.scheduleTick(pos, fluid.getType(), fluid.getType().getTickDelay((LevelReader)world));
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, this, new String[0]);
    }
}

