/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.japanese;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftime.dawnoftime.block.japanese.TatamiMatBlock;
import org.dawnoftime.dawnoftime.block.templates.BlockDoT;
import org.dawnoftime.dawnoftime.registry.DoTBBlocksRegistry;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.Nullable;

public class TatamiFloorBlock
extends BlockDoT {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;

    public TatamiFloorBlock(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.DESTROY), VoxelShapes.TATAMI_FLOOR_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)Half.TOP));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF, FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext contextIn) {
        BlockPos pos;
        Level level = contextIn.getLevel();
        BlockState currentState = level.getBlockState(pos = contextIn.getClickedPos());
        return currentState.is((Block)this) ? currentState : this.defaultBlockState();
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.isClientSide && player.isCrouching()) {
            BlockPos otherPos;
            boolean isTop = state.getValue(HALF) == Half.TOP;
            BlockPos blockPos = otherPos = isTop ? pos.relative((Direction)state.getValue((Property)FACING)) : pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
            if (isTop) {
                if (!worldIn.isEmptyBlock(pos.above())) {
                    return InteractionResult.PASS;
                }
                if (!worldIn.isEmptyBlock(otherPos.above())) {
                    return InteractionResult.PASS;
                }
            }
            worldIn.setBlock(pos, Blocks.SPRUCE_PLANKS.defaultBlockState(), 2);
            worldIn.setBlock(otherPos, Blocks.SPRUCE_PLANKS.defaultBlockState(), 2);
            worldIn.setBlock(isTop ? pos.above() : otherPos.above(), (BlockState)((BlockState)((BlockState)DoTBBlocksRegistry.INSTANCE.TATAMI_MAT.get().defaultBlockState().setValue(TatamiMatBlock.HALF, (Comparable)Half.TOP)).setValue((Property)TatamiMatBlock.FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)TatamiMatBlock.ROLLED, (Comparable)Boolean.valueOf(true)), 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos otherPos;
        Direction facing = (Direction)state.getValue((Property)FACING);
        Half half = (Half)state.getValue(HALF);
        BlockPos blockPos = otherPos = half == Half.TOP ? pos.relative(facing) : pos.relative(facing.getOpposite());
        if (half.equals((Object)Half.TOP)) {
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)DoTBBlocksRegistry.INSTANCE.TATAMI_MAT.get().asItem(), 1));
        }
        world.setBlock(otherPos, Blocks.SPRUCE_PLANKS.defaultBlockState(), 10);
        world.setBlock(pos, Blocks.SPRUCE_PLANKS.defaultBlockState(), 10);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getOpposite())).setValue(HALF, (Comparable)(state.getValue(HALF) == Half.TOP ? Half.BOTTOM : Half.TOP));
            }
            case FRONT_BACK: {
                return (BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getOpposite());
            }
        }
        return super.mirror(state, mirrorIn);
    }
}

